#version 330 core
//#version 310 es
//precision highp float;

in vec3  vertex;
in vec3  normal;
in float v_sampler;
in vec4  v_tex_area;
in vec2  v_tex_uv;
in vec4  v_color;

uniform mat4 mat_modelview;
uniform mat4 mat_projection;


     out vec3  f_position;
     out vec3  f_normal;

flat out int   f_sampler;
flat out vec4  f_tex_area;
     out vec2  f_tex_uv;
     out vec4  f_color;

void main (void) {
    f_position = vertex;
    f_normal = normal;

    f_sampler = int(v_sampler);
    f_tex_area = v_tex_area;
    f_tex_uv = v_tex_uv;
    f_color = v_color;
    
    gl_Position = mat_projection * mat_modelview * vec4(vertex, 1.0);
}