#version 330 core
//#version 310 es
//precision highp float;

struct  DirectionalLight {
    vec3 position;	//位置
    vec3 color;		//色合い
    vec3 intensity;     //強さ
};
struct  Material{
    vec3 rateDiffuse;	//ディフューズ反射率
    vec3 rateAmbient;	//アンビエント反射率
    vec3 rateSpecular;	//スペキュラ反射率
    float Shininess;	//輝き係数
};

uniform  DirectionalLight Light;
uniform  Material Mtl;

uniform  vec3  CameraPos;
uniform  int   useLight;

uniform  float texture_size;
uniform	 sampler2D texSampler[3];
uniform  float texture_unit_size[3];

     in  vec3  f_position;
     in  vec3  f_normal;

flat in  int   f_sampler;
flat in  vec4  f_tex_area;
     in  vec2  f_tex_uv;
     in  vec4  f_color;

     out vec4  fragColor;


vec3 shadePhong(DirectionalLight light, Material mtl, vec3 pos, vec3 nor, vec3 cam){
    vec3 n = normalize(nor);
    vec3 s = normalize(light.position - pos);
    vec3 v = normalize(cam - pos);
    vec3 r = normalize(-s - 2.0 * n * dot(-s, n));

    return light.intensity * light.color * min(
    	mtl.rateAmbient
    	+ mtl.rateDiffuse * (max(dot(s,n), 0.0))
    	+ mtl.rateSpecular * pow(max(dot(r,v), 0.0), mtl.Shininess),
		1.0);
}

void main (void) {
	vec2 tex_uv = f_tex_area.zw * min(max(f_tex_uv, 1.0 / (abs(f_tex_area.z) + abs(f_tex_area.w))), 1.0 - 1.0 / (abs(f_tex_area.z) + abs(f_tex_area.w)));

	// repeat if w > texture_unit_size or h > texture_unit_size
	float repeat_unit = 2 * texture_unit_size[f_sampler];
	vec2 tex_pos = texture_unit_size[f_sampler] > 0 ? min(mod(tex_uv, repeat_unit), repeat_unit - mod(tex_uv, repeat_unit)) : tex_uv;
	
	vec4 noLightColor = texture(texSampler[f_sampler], (f_tex_area.xy + tex_pos) / texture_size) * f_color;
    vec4 useLightColor = vec4(shadePhong(Light, Mtl, f_position, f_normal, CameraPos), 1.0) * noLightColor;
   	
   	fragColor = useLight == 1 ? useLightColor : noLightColor;
}