/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.ui.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.parser.XMLLayoutHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLLayoutParser {
    private final Map<String, ComponentHandler> handlers = new HashMap<String, ComponentHandler>();

    public void addHandler(String name, ComponentHandler handler) {
        this.handlers.put(name, handler);
    }

    public Component parse(DisplayInfo display, InputStream is) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        XMLLayoutHandler handler = new XMLLayoutHandler(display, this.handlers);
        parser.parse(is, (DefaultHandler)handler);
        return handler.getRootComponent();
    }

    public Component parse(DisplayInfo display, String src) throws Exception {
        return this.parse(display, new ByteArrayInputStream(src.getBytes("utf-8")));
    }

    public Component parseOrElse(DisplayInfo display, InputStream is, Supplier<Component> elseComponent) {
        try {
            return this.parse(display, is);
        }
        catch (Exception e) {
            e.printStackTrace();
            return elseComponent.get();
        }
    }

    public Component parseOrElse(DisplayInfo display, String src, Supplier<Component> elseComponent) {
        try {
            return this.parse(display, src);
        }
        catch (Exception e) {
            e.printStackTrace();
            return elseComponent.get();
        }
    }

    public static interface ComponentHandler {
        public Component create(DisplayInfo var1, Attributes var2) throws SAXException;
    }
}

