/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.ui.parser;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;
import net.comp_lot.ui.parser.XMLLayoutParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XMLLayoutHandler
extends DefaultHandler {
    private final DisplayInfo display;
    private final Map<String, XMLLayoutParser.ComponentHandler> handlers;
    private Component rootComponent;
    private final Deque<Layout> layoutStack = new ArrayDeque<Layout>();

    XMLLayoutHandler(DisplayInfo display, Map<String, XMLLayoutParser.ComponentHandler> handlers) {
        this.display = display;
        this.handlers = handlers;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
        if (this.handlers.containsKey(qName)) {
            Component component = this.handlers.get(qName).create(this.display, attr);
            this.handleParent(component, attr);
            if (component instanceof Layout) {
                this.layoutStack.addLast((Layout)component);
            }
        } else {
            throw new SAXException(String.format("tag \"%s\" is undefined", qName));
        }
    }

    private void handleParent(Component component, Attributes attr) {
        if (this.rootComponent == null) {
            this.rootComponent = component;
        } else {
            Layout parent = this.layoutStack.getLast();
            parent.add(component);
            int i = 0;
            while (i < attr.getLength()) {
                if (attr.getQName(i).startsWith("parent-")) {
                    parent.setChildAttribute(component, attr.getQName(i), attr.getValue(i));
                }
                ++i;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.layoutStack.getLast().getClass().getSimpleName().equals(qName)) {
            this.layoutStack.removeLast();
        }
    }

    Component getRootComponent() {
        return this.rootComponent;
    }
}

