/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.ui.layout;

import java.util.Map;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;

public class VerticalLinearLayout
extends Layout {
    public static final Placer FILL = (x, y, width, height, c) -> c.setRect(x, y, width, height);
    public static final Placer CENTER = (x, y, width, height, c) -> {
        int cw = Math.min(width, c.getPreferredWidth(width, height));
        c.setRect(x + (width - cw) / 2, y, cw, height);
    };
    public static final Placer LEFT = (x, y, width, height, c) -> {
        int cw = Math.min(width, c.getPreferredWidth(width, height));
        c.setRect(x, y, cw, height);
    };
    public static final Placer RIGHT = (x, y, width, height, c) -> {
        int cw = Math.min(width, c.getPreferredWidth(width, height));
        c.setRect(x + (width - cw), y, cw, height);
    };
    private static final Map<String, Placer> PLACERS = Map.of("fill", FILL, "center", CENTER, "left", LEFT, "right", RIGHT);
    private boolean reverse = false;
    private int margin;
    private Placer placer = FILL;

    public VerticalLinearLayout(DisplayInfo display) {
        super(display);
    }

    public VerticalLinearLayout(DisplayInfo display, int margin) {
        this(display);
        this.setChildMargin(margin);
    }

    public void setChildMargin(int margin) {
        this.margin = margin;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public void setAlign(Placer placer) {
        this.placer = placer;
    }

    @Override
    public void setAttribute(String name, String value) {
        switch (name) {
            case "child-margin": {
                this.setChildMargin(Integer.parseInt(value));
                break;
            }
            case "child-align": {
                this.setAlign(PLACERS.get(value));
                break;
            }
            case "reverse": {
                this.setReverse(Boolean.parseBoolean(value));
                break;
            }
            default: {
                super.setAttribute(name, value);
            }
        }
    }

    @Override
    protected int preferredHeight() {
        int scaledMargin = (int)((double)this.margin * this.getDisplay().getScale());
        int height = this.getChildren().stream().mapToInt(c -> c.getPreferredHeight() + scaledMargin).sum();
        return height == 0 ? 0 : height - scaledMargin;
    }

    @Override
    protected int preferredHeight(int maxWidth, int maxHeight) {
        int scaledMargin = (int)((double)this.margin * this.getDisplay().getScale());
        int height = this.getChildren().stream().mapToInt(c -> c.getPreferredHeight(maxWidth, maxHeight) + scaledMargin).sum();
        return height == 0 ? 0 : height - scaledMargin;
    }

    @Override
    public void layout(int x, int y, int width, int height) {
        int scaledMargin = (int)((double)this.margin * this.getDisplay().getScale());
        Int heightSum = new Int();
        this.forEach(c -> {
            int ch = Math.min(c.getPreferredHeight(width, height), height - intVal.i);
            if (this.reverse) {
                this.placer.setPlace(x, y + height - intVal.i - ch, width, ch, (Component)c);
            } else {
                this.placer.setPlace(x, y + intVal.i, width, ch, (Component)c);
            }
            intVal.i += scaledMargin + c.getPreferredHeight(width, height);
            intVal.i = Math.min(intVal.i, height);
        });
    }

    private static class Int {
        int i = 0;

        private Int() {
        }
    }

    private static interface Placer {
        public void setPlace(int var1, int var2, int var3, int var4, Component var5);
    }
}

