/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.ui.layout;

import java.util.HashMap;
import java.util.Map;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;

public class TileLayout
extends Layout {
    private final Map<Component, TileConstraint> map = new HashMap<Component, TileConstraint>();
    private int tileWidth;
    private int tileHeight;
    private boolean autoSize = false;
    private double scale = 1.0;
    private boolean fixCenter = false;
    private double centerX;
    private double centerY;

    public TileLayout(DisplayInfo display) {
        this(display, 128);
    }

    public TileLayout(DisplayInfo display, int tileSize) {
        this(display, tileSize, tileSize);
    }

    public TileLayout(DisplayInfo display, int tileWidth, int tileHeight) {
        super(display);
        this.setTileWidth(tileWidth);
        this.setTileHeight(tileHeight);
    }

    public void setTileSize(int tileSize) {
        this.setTileWidth(tileSize);
        this.setTileHeight(tileSize);
    }

    public void setTileWidth(int tileWidth) {
        this.tileWidth = tileWidth;
    }

    public void setTileHeight(int tileHeight) {
        this.tileHeight = tileHeight;
    }

    public int getTileWidth() {
        return (int)((double)this.tileWidth * this.scale);
    }

    public int getTileHeight() {
        return (int)((double)this.tileHeight * this.scale);
    }

    public void setAutoSize(boolean autoSize) {
        this.autoSize = autoSize;
        if (!autoSize) {
            this.scale = 1.0;
        }
    }

    public void setCenter(double centerX, double centerY) {
        this.fixCenter = true;
        this.centerX = centerX;
        this.centerY = centerY;
    }

    @Override
    public void add(Component c) {
        this.map.put(c, new TileConstraint(c, 0.0, 0.0));
        super.add(c);
    }

    @Override
    public void remove(Component c) {
        super.remove(c);
        this.map.remove(c);
    }

    @Override
    public void clear() {
        super.clear();
        this.map.clear();
    }

    public void setPlace(Component c, double x, double y) {
        TileConstraint tc = this.map.get(c);
        tc.x = x;
        tc.y = y;
    }

    public void setScale(Component c, double scale) {
        TileConstraint tc = this.map.get(c);
        tc.scale = scale;
    }

    public double toTileX(int pixelX) {
        return (double)(pixelX - this.getRect().getX() + this.getLeft()) / (double)this.getTileWidth();
    }

    public double toTileY(int pixelY) {
        return (double)(pixelY - this.getRect().getY() + this.getTop()) / (double)this.getTileHeight();
    }

    public int toPixelX(double tileX) {
        return (int)(tileX * (double)this.getTileWidth()) + this.getRect().getX() - this.getLeft();
    }

    public int toPixelY(double tileY) {
        return (int)(tileY * (double)this.getTileHeight()) + this.getRect().getY() - this.getTop();
    }

    private int getLeft() {
        return this.getChildren().stream().map(c -> this.map.get(c)).mapToInt(tc -> tc.getX()).min().orElseGet(() -> 0);
    }

    private int getRight() {
        return this.getChildren().stream().map(c -> this.map.get(c)).mapToInt(tc -> tc.getX() + tc.getWidth()).max().orElseGet(() -> 0);
    }

    private int getTop() {
        return this.getChildren().stream().map(c -> this.map.get(c)).mapToInt(tc -> tc.getY()).min().orElseGet(() -> 0);
    }

    private int getBottom() {
        return this.getChildren().stream().map(c -> this.map.get(c)).mapToInt(tc -> tc.getY() + tc.getHeight()).max().orElseGet(() -> 0);
    }

    @Override
    protected int preferredWidth() {
        if (this.autoSize) {
            return Short.MAX_VALUE;
        }
        return this.getRight() - this.getLeft();
    }

    @Override
    protected int preferredHeight() {
        if (this.autoSize) {
            return Short.MAX_VALUE;
        }
        return this.getBottom() - this.getTop();
    }

    @Override
    protected int preferredWidth(int maxWidht, int maxHeight) {
        return this.preferredWidth();
    }

    @Override
    protected int preferredHeight(int maxWidht, int maxHeight) {
        return this.preferredHeight();
    }

    @Override
    public void setAttribute(String name, String value) {
        switch (name) {
            case "tile-size": {
                this.setTileSize(Integer.parseInt(value));
                break;
            }
            case "tile-width": {
                this.setTileWidth(Integer.parseInt(value));
                break;
            }
            case "tile-height": {
                this.setTileHeight(Integer.parseInt(value));
                break;
            }
            case "auto-size": {
                this.setAutoSize(Boolean.parseBoolean(value));
                break;
            }
            default: {
                super.setAttribute(name, value);
            }
        }
    }

    @Override
    public void setChildAttribute(Component child, String name, String value) {
        switch (name) {
            case "parent-place": {
                String[] values = value.split(" *, *");
                this.setPlace(child, Double.parseDouble(values[0]), Double.parseDouble(values[1]));
                break;
            }
            case "parent-scale": {
                this.setScale(child, Double.parseDouble(value));
                break;
            }
            default: {
                super.setChildAttribute(child, name, value);
            }
        }
    }

    @Override
    protected void layout(int x, int y, int width, int height) {
        if (this.autoSize) {
            this.scale = this.getRight() - this.getLeft() == 0 || this.getBottom() - this.getTop() == 0 ? 1.0 : Math.min((double)width / (double)(this.getRight() - this.getLeft()), (double)height / (double)(this.getBottom() - this.getTop()));
        }
        int left = this.fixCenter ? -width / 2 + (int)(this.centerX * (double)this.getTileWidth()) : this.getLeft();
        int top = this.fixCenter ? -height / 2 + (int)(this.centerY * (double)this.getTileHeight()) : this.getTop();
        this.forEach(c -> {
            TileConstraint tc = this.map.get(c);
            c.setRect(x - left + tc.getX(), y - top + tc.getY(), tc.getWidth(), tc.getHeight());
        });
    }

    private class TileConstraint {
        final Component c;
        double x;
        double y;
        double scale;

        TileConstraint(Component c, double x, double y) {
            this(c, x, y, 1.0);
        }

        TileConstraint(Component c, double x, double y, double scale) {
            this.c = c;
            this.x = x;
            this.y = y;
            this.scale = scale;
        }

        int getWidth() {
            return this.scale > 0.0 ? (int)((double)TileLayout.this.getTileWidth() * this.scale) : this.c.getPreferredWidth();
        }

        int getHeight() {
            return this.scale > 0.0 ? (int)((double)TileLayout.this.getTileHeight() * this.scale) : this.c.getPreferredHeight();
        }

        int getX() {
            return (int)(this.x * (double)TileLayout.this.getTileWidth()) - this.getWidth() / 2;
        }

        int getY() {
            return (int)(this.y * (double)TileLayout.this.getTileHeight()) - this.getHeight() / 2;
        }
    }
}

