/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.ui.layout;

import java.util.function.Function;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.CursorType;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;

public class ScrollLayout
extends Layout {
    private boolean allowVertical;
    private boolean allowHorizontal;
    private int scrollX;
    private int scrollY;
    private Component barHorizontal;
    private Component barVertical;
    private static Function<DisplayInfo, Component> defaultScrollBar = display -> null;

    public ScrollLayout(DisplayInfo display) {
        this(display, true, true);
    }

    public ScrollLayout(DisplayInfo display, boolean allowVertical, boolean allowHorizontal) {
        super(display);
        this.allowVertical = allowVertical;
        this.allowHorizontal = allowHorizontal;
        this.barHorizontal = defaultScrollBar.apply(display);
        this.barVertical = defaultScrollBar.apply(display);
    }

    public ScrollLayout(DisplayInfo display, Component child) {
        this(display, child, true, true);
    }

    public ScrollLayout(DisplayInfo display, Component child, boolean allowVertical, boolean allowHorizontal) {
        this(display, allowVertical, allowHorizontal);
        this.add(child);
    }

    public void setBarHorizontal(Component barHorizontal) {
        this.barHorizontal = barHorizontal;
    }

    public void setBarVertical(Component barVertical) {
        this.barVertical = barVertical;
    }

    public void setAllowVertical(boolean allowVertical) {
        this.allowVertical = allowVertical;
    }

    public void setAllowHorizontal(boolean allowHorizontal) {
        this.allowHorizontal = allowHorizontal;
    }

    @Override
    public void setAttribute(String name, String value) {
        switch (name) {
            case "allow-vertical": {
                this.setAllowVertical(Boolean.parseBoolean(value));
                break;
            }
            case "allow-horizontal": {
                this.setAllowHorizontal(Boolean.parseBoolean(value));
                break;
            }
            default: {
                super.setAttribute(name, value);
            }
        }
    }

    public void scroll(int x, int y) {
        this.scrollX += x;
        this.scrollY += y;
    }

    @Override
    public boolean scroll(int scrollX, int scrollY, int mouseX, int mouseY) {
        if (!this.isInDrawingRect(mouseX, mouseY)) {
            return false;
        }
        if (super.scroll(scrollX, scrollY, mouseX, mouseY)) {
            return true;
        }
        this.scroll(scrollX, scrollY);
        return true;
    }

    public void resetScroll() {
        this.scrollX = 0;
        this.scrollY = 0;
    }

    @Override
    protected void draw(int x, int y, int width, int height) {
        super.draw(x, y, width, height);
        if (this.barHorizontal != null) {
            this.barHorizontal.callDraw();
        }
        if (this.barVertical != null) {
            this.barVertical.callDraw();
        }
    }

    @Override
    protected void layout(int x, int y, int width, int height) {
        int maxWidth = this.allowHorizontal ? 0x1000000 : width;
        int maxHeight = this.allowVertical ? 0x1000000 : height;
        int preferredWidth = this.preferredWidth(maxWidth, maxHeight);
        int preferredHeight = this.preferredHeight(maxWidth, maxHeight);
        this.boundScroll(width, height, preferredWidth, preferredHeight);
        this.forEach(c -> c.setRect(x + this.scrollX, y + this.scrollY, Math.max(c.getPreferredWidth(maxWidth, maxHeight), width), Math.max(c.getPreferredHeight(maxWidth, maxHeight), height)));
        this.setScrollBar(x, y, width, height, preferredWidth, preferredHeight);
    }

    private void setScrollBar(int x, int y, int width, int height, int preferredWidth, int preferredHeight) {
        if (width < 0 || height < 0) {
            return;
        }
        if (this.barHorizontal != null) {
            if (width < preferredWidth) {
                this.barHorizontal.setRect(x - this.scrollX * (width - 8) / preferredWidth + 4, y + height - 10, width * (width - 8) / preferredWidth, 6);
                this.barHorizontal.setVisible(true);
            } else {
                this.barHorizontal.setVisible(false);
            }
        }
        if (this.barVertical != null) {
            if (height < preferredHeight) {
                this.barVertical.setRect(x + width - 10, y - this.scrollY * (height - 8) / preferredHeight + 4, 6, height * (height - 8) / preferredHeight);
                this.barVertical.setVisible(true);
            } else {
                this.barVertical.setVisible(false);
            }
        }
    }

    private void boundScroll(int width, int height, int preferredWidth, int preferredHeight) {
        this.scrollX = Math.min(Math.max(this.scrollX, width - preferredWidth), 0);
        this.scrollY = Math.min(Math.max(this.scrollY, height - preferredHeight), 0);
    }

    @Override
    public CursorType getCursorType() {
        return this.isClickable() ? CursorType.SCROLL : CursorType.NORMAL;
    }

    public static void setDefaultScrollBar(Function<DisplayInfo, Component> defaultBar) {
        defaultScrollBar = defaultBar;
    }
}

