/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.ui.layout;

import java.util.Map;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;

public class HorizontalLinearLayout
extends Layout {
    public static final Placer FILL = (x, y, width, height, c) -> c.setRect(x, y, width, height);
    public static final Placer CENTER = (x, y, width, height, c) -> {
        int ch = Math.min(height, c.getPreferredHeight(width, height));
        c.setRect(x, y + (height - ch) / 2, width, ch);
    };
    public static final Placer TOP = (x, y, width, height, c) -> {
        int ch = Math.min(height, c.getPreferredHeight(width, height));
        c.setRect(x, y, width, ch);
    };
    public static final Placer BOTTOM = (x, y, width, height, c) -> {
        int ch = Math.min(height, c.getPreferredHeight(width, height));
        c.setRect(x, y + (height - ch), width, ch);
    };
    private static final Map<String, Placer> PLACERS = Map.of("fill", FILL, "center", CENTER, "top", TOP, "bottom", BOTTOM);
    private boolean reverse = false;
    private int margin;
    private Placer placer = FILL;

    public HorizontalLinearLayout(DisplayInfo display) {
        super(display);
    }

    public HorizontalLinearLayout(DisplayInfo display, int margin) {
        this(display);
        this.setChildMargin(margin);
    }

    public void setChildMargin(int margin) {
        this.margin = margin;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public void setAlign(Placer placer) {
        this.placer = placer;
    }

    @Override
    public void setAttribute(String name, String value) {
        switch (name) {
            case "child-margin": {
                this.setChildMargin(Integer.parseInt(value));
                break;
            }
            case "child-align": {
                this.setAlign(PLACERS.get(value));
                break;
            }
            case "reverse": {
                this.setReverse(Boolean.parseBoolean(value));
                break;
            }
            default: {
                super.setAttribute(name, value);
            }
        }
    }

    @Override
    protected int preferredWidth() {
        int scaledMargin = (int)((double)this.margin * this.getDisplay().getScale());
        int width = this.getChildren().stream().mapToInt(c -> c.getPreferredWidth() + scaledMargin).sum();
        return width == 0 ? 0 : width - scaledMargin;
    }

    @Override
    protected int preferredWidth(int maxWidth, int maxHeight) {
        int scaledMargin = (int)((double)this.margin * this.getDisplay().getScale());
        int width = this.getChildren().stream().mapToInt(c -> c.getPreferredWidth(maxWidth, maxHeight) + scaledMargin).sum();
        return width == 0 ? 0 : width - scaledMargin;
    }

    @Override
    public void layout(int x, int y, int width, int height) {
        int scaledMargin = (int)((double)this.margin * this.getDisplay().getScale());
        Int widthSum = new Int();
        this.forEach(c -> {
            int cw = Math.min(c.getPreferredWidth(width, height), width - intVal.i);
            if (this.reverse) {
                this.placer.setPlace(x + width - intVal.i - cw, y, cw, height, (Component)c);
            } else {
                this.placer.setPlace(x + intVal.i, y, cw, height, (Component)c);
            }
            intVal.i += scaledMargin + c.getPreferredWidth(width, height);
            intVal.i = Math.min(intVal.i, width);
        });
    }

    private static class Int {
        int i = 0;

        private Int() {
        }
    }

    private static interface Placer {
        public void setPlace(int var1, int var2, int var3, int var4, Component var5);
    }
}

