/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.ui.layout;

import java.util.ArrayList;
import java.util.List;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;
import net.comp_lot.ui.layout.HorizontalLinearLayout;
import net.comp_lot.ui.layout.VerticalLinearLayout;

public class GridLayout
extends Layout {
    private final Component lineSeparator;
    private final VerticalLinearLayout layout;
    private final List<HorizontalLinearLayout> lines = new ArrayList<HorizontalLinearLayout>();
    private int horizontalMargin = 0;

    public GridLayout(DisplayInfo display) {
        super(display);
        this.lineSeparator = new Component(display){

            @Override
            protected int preferredWidth() {
                return 0;
            }

            @Override
            protected int preferredHeight() {
                return 0;
            }

            @Override
            protected void draw(int x, int y, int width, int height) {
            }
        };
        this.layout = new VerticalLinearLayout(display, 0);
        this.layout.setAlign(VerticalLinearLayout.LEFT);
    }

    public Component getLineSeparator() {
        return this.lineSeparator;
    }

    public void setHorizontalMargin(int margin) {
        this.horizontalMargin = margin;
    }

    public void setVerticalMargin(int margin) {
        this.layout.setChildMargin(margin);
    }

    @Override
    public void setAttribute(String name, String value) {
        switch (name) {
            case "child-horizontal-margin": {
                this.setHorizontalMargin(Integer.parseInt(value));
                break;
            }
            case "child-vertical-margin": {
                this.setVerticalMargin(Integer.parseInt(value));
                break;
            }
            default: {
                super.setAttribute(name, value);
            }
        }
    }

    @Override
    protected int preferredWidth() {
        return this.getChildren().stream().mapToInt(c -> c.getPreferredWidth()).sum();
    }

    @Override
    protected int preferredWidth(int maxWidth, int maxHeight) {
        this.layout(maxWidth, maxHeight);
        return this.layout.getPreferredWidth(maxWidth, maxHeight);
    }

    @Override
    protected int preferredHeight(int maxWidth, int maxHeight) {
        this.layout(maxWidth, maxHeight);
        return this.layout.getPreferredHeight(maxWidth, maxHeight);
    }

    @Override
    protected void layout(int x, int y, int width, int height) {
        this.layout(width, height);
        this.layout.setRect(x, y, width, height);
    }

    private void layout(int width, int height) {
        this.layout.clear();
        this.addLine();
        this.forEach(c -> {
            if (c == this.lineSeparator) {
                this.addLine();
            } else if (this.getLastLine().getPreferredWidth(width, height) + c.getPreferredWidth(width, height) <= width) {
                this.getLastLine().add((Component)c);
            } else {
                this.addLine();
                this.getLastLine().add((Component)c);
            }
        });
    }

    private Layout getLastLine() {
        return this.lines.get(this.layout.getChildren().size() - 1);
    }

    private void addLine() {
        if (this.layout.getChildren().size() >= this.lines.size()) {
            this.lines.add(new HorizontalLinearLayout(this.getDisplay(), 0));
        }
        HorizontalLinearLayout line = this.lines.get(this.layout.getChildren().size());
        line.clear();
        line.setChildMargin(this.horizontalMargin);
        this.layout.add(line);
    }
}

