/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.ui.layout;

import java.util.HashMap;
import java.util.Map;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;

public class AlignmentLayout
extends Layout {
    private final Map<Component, HorizontalPlacer> horizontalMap = new HashMap<Component, HorizontalPlacer>();
    private final Map<Component, VerticalPlacer> verticalMap = new HashMap<Component, VerticalPlacer>();
    private final Map<String, HorizontalPlacer> HORIZONTAL_PLACERS = Map.of("fill", HORIZONTAL_FILL, "center", HORIZONTAL_CENTER, "left", HORIZONTAL_LEFT, "right", HORIZONTAL_RIGHT);
    private final Map<String, VerticalPlacer> VERTICAL_PLACERS = Map.of("fill", VERTICAL_FILL, "center", VERTICAL_CENTER, "top", VERTICAL_TOP, "bottom", VERTICAL_BOTTOM);
    public static final HorizontalPlacer HORIZONTAL_FILL = new HorizontalPlacer(){

        @Override
        public int getX(int x, int y, int width, int height, Component c) {
            return x;
        }

        @Override
        public int getWidth(int x, int y, int width, int height, Component c) {
            return width;
        }
    };
    public static final HorizontalPlacer HORIZONTAL_CENTER = new HorizontalPlacer(){

        @Override
        public int getX(int x, int y, int width, int height, Component c) {
            int cw = Math.min(width, c.getPreferredWidth(width, height));
            return x + (width - cw) / 2;
        }

        @Override
        public int getWidth(int x, int y, int width, int height, Component c) {
            int cw = Math.min(width, c.getPreferredWidth(width, height));
            return cw;
        }
    };
    public static final HorizontalPlacer HORIZONTAL_LEFT = new HorizontalPlacer(){

        @Override
        public int getX(int x, int y, int width, int height, Component c) {
            return x;
        }

        @Override
        public int getWidth(int x, int y, int width, int height, Component c) {
            int cw = Math.min(width, c.getPreferredWidth(width, height));
            return cw;
        }
    };
    public static final HorizontalPlacer HORIZONTAL_RIGHT = new HorizontalPlacer(){

        @Override
        public int getX(int x, int y, int width, int height, Component c) {
            int cw = Math.min(width, c.getPreferredWidth(width, height));
            return x + width - cw;
        }

        @Override
        public int getWidth(int x, int y, int width, int height, Component c) {
            int cw = Math.min(width, c.getPreferredWidth(width, height));
            return cw;
        }
    };
    public static final VerticalPlacer VERTICAL_FILL = new VerticalPlacer(){

        @Override
        public int getY(int x, int y, int width, int height, Component c) {
            return y;
        }

        @Override
        public int getHeight(int x, int y, int width, int height, Component c) {
            return height;
        }
    };
    public static final VerticalPlacer VERTICAL_CENTER = new VerticalPlacer(){

        @Override
        public int getY(int x, int y, int width, int height, Component c) {
            int ch = Math.min(height, c.getPreferredHeight(width, height));
            return y + (height - ch) / 2;
        }

        @Override
        public int getHeight(int x, int y, int width, int height, Component c) {
            int ch = Math.min(height, c.getPreferredHeight(width, height));
            return ch;
        }
    };
    public static final VerticalPlacer VERTICAL_TOP = new VerticalPlacer(){

        @Override
        public int getY(int x, int y, int width, int height, Component c) {
            return y;
        }

        @Override
        public int getHeight(int x, int y, int width, int height, Component c) {
            int ch = Math.min(height, c.getPreferredHeight(width, height));
            return ch;
        }
    };
    public static final VerticalPlacer VERTICAL_BOTTOM = new VerticalPlacer(){

        @Override
        public int getY(int x, int y, int width, int height, Component c) {
            int ch = Math.min(height, c.getPreferredHeight(width, height));
            return y + height - ch;
        }

        @Override
        public int getHeight(int x, int y, int width, int height, Component c) {
            int ch = Math.min(height, c.getPreferredHeight(width, height));
            return ch;
        }
    };

    public AlignmentLayout(DisplayInfo display) {
        super(display);
    }

    @Override
    public void add(Component c) {
        this.horizontalMap.put(c, HORIZONTAL_CENTER);
        this.verticalMap.put(c, VERTICAL_CENTER);
        super.add(c);
    }

    @Override
    public void remove(Component c) {
        super.remove(c);
        this.horizontalMap.remove(c);
        this.verticalMap.remove(c);
    }

    public void setHorizontalAlign(Component c, HorizontalPlacer align) {
        this.horizontalMap.put(c, align);
    }

    public void setVerticalAlign(Component c, VerticalPlacer align) {
        this.verticalMap.put(c, align);
    }

    @Override
    public void setChildAttribute(Component child, String name, String value) {
        switch (name) {
            case "parent-align-horizontal": {
                this.setHorizontalAlign(child, this.HORIZONTAL_PLACERS.get(value));
                break;
            }
            case "parent-align-vertical": {
                this.setVerticalAlign(child, this.VERTICAL_PLACERS.get(value));
                break;
            }
            case "parent-between-horizontal": {
                this.setHorizontalAlign(child, AlignmentLayout.horizontalBetween(this.getComponentByName(value.split(",")[0]), this.getComponentByName(value.split(",")[1])));
                break;
            }
            case "parent-between-vertical": {
                this.setVerticalAlign(child, AlignmentLayout.verticalBetween(this.getComponentByName(value.split(",")[0]), this.getComponentByName(value.split(",")[1])));
                break;
            }
            case "parent-to-left-of": {
                this.setHorizontalAlign(child, AlignmentLayout.toLeftOf(this.getComponentByName(value)));
                break;
            }
            case "parent-to-right-of": {
                this.setHorizontalAlign(child, AlignmentLayout.toRightOf(this.getComponentByName(value)));
                break;
            }
            case "parent-above": {
                this.setVerticalAlign(child, AlignmentLayout.above(this.getComponentByName(value)));
                break;
            }
            case "parent-below": {
                this.setVerticalAlign(child, AlignmentLayout.below(this.getComponentByName(value)));
                break;
            }
            case "parent-align-left": {
                this.setHorizontalAlign(child, AlignmentLayout.alignLeft(this.getComponentByName(value)));
                break;
            }
            case "parent-align-right": {
                this.setHorizontalAlign(child, AlignmentLayout.alignRight(this.getComponentByName(value)));
                break;
            }
            case "parent-align-top": {
                this.setVerticalAlign(child, AlignmentLayout.alignTop(this.getComponentByName(value)));
                break;
            }
            case "parent-align-bottom": {
                this.setVerticalAlign(child, AlignmentLayout.alignBottom(this.getComponentByName(value)));
                break;
            }
            default: {
                super.setChildAttribute(child, name, value);
            }
        }
    }

    @Override
    protected void layout(int x, int y, int width, int height) {
        this.forEach(c -> {
            HorizontalPlacer hp = this.horizontalMap.get(c);
            VerticalPlacer vp = this.verticalMap.get(c);
            c.setRect(hp.getX(x, y, width, height, (Component)c), vp.getY(x, y, width, height, (Component)c), hp.getWidth(x, y, width, height, (Component)c), vp.getHeight(x, y, width, height, (Component)c));
        });
    }

    public static HorizontalPlacer horizontalBetween(final Component a, final Component b) {
        return new HorizontalPlacer(){

            @Override
            public int getX(int x, int y, int width, int height, Component c) {
                return Math.min(a.getRect().getX() + a.getRect().getWidth(), b.getRect().getX() + b.getRect().getWidth());
            }

            @Override
            public int getWidth(int x, int y, int width, int height, Component c) {
                return Math.max(a.getRect().getX(), b.getRect().getX()) - Math.min(a.getRect().getX() + a.getRect().getWidth(), b.getRect().getX() + b.getRect().getWidth());
            }
        };
    }

    public static VerticalPlacer verticalBetween(final Component a, final Component b) {
        return new VerticalPlacer(){

            @Override
            public int getY(int x, int y, int width, int height, Component c) {
                return Math.min(a.getRect().getY() + a.getRect().getHeight(), b.getRect().getY() + b.getRect().getHeight());
            }

            @Override
            public int getHeight(int x, int y, int width, int height, Component c) {
                return Math.max(a.getRect().getY(), b.getRect().getY()) - Math.min(a.getRect().getY() + a.getRect().getHeight(), b.getRect().getY() + b.getRect().getHeight());
            }
        };
    }

    public static HorizontalPlacer toLeftOf(final Component target) {
        return new HorizontalPlacer(){

            @Override
            public int getX(int x, int y, int width, int height, Component c) {
                return target.getRect().getX() - this.getWidth(x, y, width, height, c);
            }

            @Override
            public int getWidth(int x, int y, int width, int height, Component c) {
                return Math.min(target.getRect().getX() - x, c.getPreferredWidth(width, height));
            }
        };
    }

    public static HorizontalPlacer toRightOf(final Component target) {
        return new HorizontalPlacer(){

            @Override
            public int getX(int x, int y, int width, int height, Component c) {
                return target.getRect().getX() + target.getRect().getWidth();
            }

            @Override
            public int getWidth(int x, int y, int width, int height, Component c) {
                return Math.min(x + width - this.getX(x, y, width, height, c), c.getPreferredWidth(width, height));
            }
        };
    }

    public static VerticalPlacer above(final Component target) {
        return new VerticalPlacer(){

            @Override
            public int getY(int x, int y, int width, int height, Component c) {
                return target.getRect().getY() - this.getHeight(x, y, width, height, c);
            }

            @Override
            public int getHeight(int x, int y, int width, int height, Component c) {
                return Math.min(target.getRect().getY() - y, c.getPreferredHeight(width, height));
            }
        };
    }

    public static VerticalPlacer below(final Component target) {
        return new VerticalPlacer(){

            @Override
            public int getY(int x, int y, int width, int height, Component c) {
                return target.getRect().getY() + target.getRect().getHeight();
            }

            @Override
            public int getHeight(int x, int y, int width, int height, Component c) {
                return Math.min(y + height - this.getY(x, y, width, height, c), c.getPreferredHeight(width, height));
            }
        };
    }

    public static HorizontalPlacer alignLeft(final Component target) {
        return new HorizontalPlacer(){

            @Override
            public int getX(int x, int y, int width, int height, Component c) {
                return target.getRect().getX();
            }

            @Override
            public int getWidth(int x, int y, int width, int height, Component c) {
                return Math.min(x + width - target.getRect().getX(), c.getPreferredWidth(width, height));
            }
        };
    }

    public static HorizontalPlacer alignRight(final Component target) {
        return new HorizontalPlacer(){

            @Override
            public int getX(int x, int y, int width, int height, Component c) {
                int cw = Math.min(target.getRect().getX() + target.getRect().getWidth() - x, c.getPreferredWidth(width, height));
                return target.getRect().getX() + target.getRect().getWidth() - cw;
            }

            @Override
            public int getWidth(int x, int y, int width, int height, Component c) {
                int cw = Math.min(target.getRect().getX() + target.getRect().getWidth() - x, c.getPreferredWidth(width, height));
                return cw;
            }
        };
    }

    public static VerticalPlacer alignTop(final Component target) {
        return new VerticalPlacer(){

            @Override
            public int getY(int x, int y, int width, int height, Component c) {
                return target.getRect().getY();
            }

            @Override
            public int getHeight(int x, int y, int width, int height, Component c) {
                return Math.min(y + height - target.getRect().getY(), c.getPreferredHeight(width, height));
            }
        };
    }

    public static VerticalPlacer alignBottom(final Component target) {
        return new VerticalPlacer(){

            @Override
            public int getY(int x, int y, int width, int height, Component c) {
                int ch = Math.min(target.getRect().getY() + target.getRect().getHeight() - y, c.getPreferredHeight(width, height));
                return target.getRect().getY() + target.getRect().getHeight() - ch;
            }

            @Override
            public int getHeight(int x, int y, int width, int height, Component c) {
                int ch = Math.min(target.getRect().getY() + target.getRect().getHeight() - y, c.getPreferredHeight(width, height));
                return ch;
            }
        };
    }

    private static interface HorizontalPlacer {
        public int getX(int var1, int var2, int var3, int var4, Component var5);

        public int getWidth(int var1, int var2, int var3, int var4, Component var5);
    }

    private static interface VerticalPlacer {
        public int getY(int var1, int var2, int var3, int var4, Component var5);

        public int getHeight(int var1, int var2, int var3, int var4, Component var5);
    }
}

