/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.ui.layout;

import java.util.HashMap;
import java.util.Map;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;
import net.comp_lot.ui.core.Rect;

public class AbsoluteLayout
extends Layout {
    private final Map<Component, Rect> map = new HashMap<Component, Rect>();

    public AbsoluteLayout(DisplayInfo display) {
        super(display);
    }

    public void setPlace(Component c, int x, int y) {
        this.map.put(c, new Rect(x, y, 0, 0));
    }

    @Override
    public void setChildAttribute(Component child, String name, String value) {
        switch (name) {
            case "parent-place": {
                String[] values = value.split(" *, *");
                this.setPlace(child, Integer.parseInt(values[0]), Integer.parseInt(values[1]));
                break;
            }
            default: {
                super.setChildAttribute(child, name, value);
            }
        }
    }

    @Override
    public void add(Component c) {
        this.map.put(c, new Rect(0, 0, 0, 0));
        super.add(c);
    }

    @Override
    public void remove(Component c) {
        super.remove(c);
        this.map.remove(c);
    }

    @Override
    protected void layout(int x, int y, int width, int height) {
        this.forEach(c -> c.setRect(x + this.map.get(c).getX(), y + this.map.get(c).getY(), c.getPreferredWidth(), c.getPreferredHeight()));
    }
}

