/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.ui.core;

public class Rect {
    private final int x;
    private final int y;
    private final int width;
    private final int height;

    public Rect(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Rect createExpandedRect(int left, int right, int top, int bottom) {
        return new Rect(this.x - left, this.y - top, this.width + (left + right), this.height + (top + bottom));
    }

    public boolean contain(int x, int y) {
        return this.x <= x && x < this.x + this.width && this.y <= y && y < this.y + this.height;
    }

    public boolean contain(Rect a) {
        return this.contain(a.x, a.y) && this.contain(a.x + a.width, a.y) && this.contain(a.x, a.y + a.height) && this.contain(a.x + a.width, a.y + a.height);
    }

    public boolean crossing(Rect a) {
        return this.x + this.width >= a.x && a.x + a.width >= this.x && this.y + this.height >= a.y && a.y + a.height >= this.y;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Rect)) {
            return false;
        }
        Rect r = (Rect)o;
        return this.x == r.x && this.y == r.y && this.width == r.width && this.height == r.height;
    }

    public Rect clip(Rect a) {
        if (!this.crossing(a)) {
            return new Rect(0, 0, 0, 0);
        }
        int cx = Math.max(this.x, a.x);
        int cy = Math.max(this.y, a.y);
        int cw = Math.min(this.x + this.width, a.x + a.width) - cx;
        int ch = Math.min(this.y + this.height, a.y + a.height) - cy;
        return new Rect(cx, cy, cw, ch);
    }
}

