/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.ui.core;

import net.comp_lot.ui.core.Rect;

public abstract class Layoutable {
    private Rect outlineRect = new Rect(0, 0, 0, 0);
    private Rect rect = new Rect(0, 0, 0, 0);
    private Rect contentRect = new Rect(0, 0, 0, 0);
    private int minWidth = 0;
    private int minHeight = 0;
    private int maxWidth = 0x1000000;
    private int maxHeight = 0x1000000;
    private int marginLeft;
    private int marginRight;
    private int marginTop;
    private int marginBottom;
    private int paddingLeft;
    private int paddingRight;
    private int paddingTop;
    private int paddingBottom;

    public void setRect(int x, int y, int width, int height) {
        this.outlineRect = new Rect(x, y, width, height);
        this.rect = this.outlineRect.createExpandedRect(-this.marginLeft, -this.marginRight, -this.marginTop, -this.marginBottom);
        this.contentRect = this.rect.createExpandedRect(-this.paddingLeft, -this.paddingRight, -this.paddingTop, -this.paddingBottom);
    }

    public final Rect getOutlineRect() {
        return this.outlineRect;
    }

    public final Rect getRect() {
        return this.rect;
    }

    public final Rect getContentRect() {
        return this.contentRect;
    }

    protected abstract int preferredWidth();

    protected abstract int preferredHeight();

    protected int preferredWidth(int maxWidth, int maxHeight) {
        return this.preferredWidth();
    }

    protected int preferredHeight(int maxWidth, int maxHeight) {
        return this.preferredHeight();
    }

    public final int getPreferredWidth() {
        return this.getPreferredWidth(this.maxWidth, this.maxHeight);
    }

    public final int getPreferredHeight() {
        return this.getPreferredHeight(this.maxWidth, this.maxHeight);
    }

    public final int getPreferredWidth(int maxWidth, int maxHeight) {
        int remainW = this.marginLeft + this.marginRight + this.paddingLeft + this.paddingRight;
        int remainH = this.marginTop + this.marginBottom + this.paddingTop + this.paddingBottom;
        return Math.min(Math.max(this.preferredWidth(Math.min(maxWidth - remainW, this.maxWidth), Math.min(maxHeight - remainH, this.maxHeight)), this.minWidth), this.maxWidth) + remainW;
    }

    public final int getPreferredHeight(int maxWidth, int maxHeight) {
        int remainW = this.marginLeft + this.marginRight + this.paddingLeft + this.paddingRight;
        int remainH = this.marginTop + this.marginBottom + this.paddingTop + this.paddingBottom;
        return Math.min(Math.max(this.preferredHeight(Math.min(maxWidth - remainW, this.maxWidth), Math.min(maxHeight - remainH, this.maxHeight)), this.minHeight), this.maxHeight) + remainH;
    }

    public void setWidth(int width) {
        this.setMinWidth(width);
        this.setMaxWidth(width);
    }

    public void setHeight(int height) {
        this.setMinHeight(height);
        this.setMaxHeight(height);
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public final void setMargin(int margin) {
        this.marginLeft = margin;
        this.marginRight = margin;
        this.marginTop = margin;
        this.marginBottom = margin;
    }

    public final void setPadding(int padding) {
        this.paddingLeft = padding;
        this.paddingRight = padding;
        this.paddingTop = padding;
        this.paddingBottom = padding;
    }

    public void setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
    }

    public void setMarginRight(int marginRight) {
        this.marginRight = marginRight;
    }

    public void setMarginTop(int marginTop) {
        this.marginTop = marginTop;
    }

    public void setMarginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
    }

    public void setPaddingLeft(int paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public void setPaddingRight(int paddingRight) {
        this.paddingRight = paddingRight;
    }

    public void setPaddingTop(int paddingTop) {
        this.paddingTop = paddingTop;
    }

    public void setPaddingBottom(int paddingBottom) {
        this.paddingBottom = paddingBottom;
    }

    public void setAttribute(String name, String value) {
        switch (name) {
            case "width": {
                this.setWidth(Integer.parseInt(value));
                break;
            }
            case "height": {
                this.setHeight(Integer.parseInt(value));
                break;
            }
            case "min-width": {
                this.setMinWidth(Integer.parseInt(value));
                break;
            }
            case "min-height": {
                this.setMinHeight(Integer.parseInt(value));
                break;
            }
            case "max-width": {
                this.setMaxWidth(Integer.parseInt(value));
                break;
            }
            case "max-height": {
                this.setMaxHeight(Integer.parseInt(value));
                break;
            }
            case "margin": {
                this.setMargin(Integer.parseInt(value));
                break;
            }
            case "margin-right": {
                this.setMarginRight(Integer.parseInt(value));
                break;
            }
            case "margin-left": {
                this.setMarginLeft(Integer.parseInt(value));
                break;
            }
            case "margin-top": {
                this.setMarginTop(Integer.parseInt(value));
                break;
            }
            case "margin-bottom": {
                this.setMarginBottom(Integer.parseInt(value));
                break;
            }
            case "padding": {
                this.setPadding(Integer.parseInt(value));
                break;
            }
            case "padding-right": {
                this.setPaddingRight(Integer.parseInt(value));
                break;
            }
            case "padding-left": {
                this.setPaddingLeft(Integer.parseInt(value));
                break;
            }
            case "padding-top": {
                this.setPaddingTop(Integer.parseInt(value));
                break;
            }
            case "padding-bottom": {
                this.setPaddingBottom(Integer.parseInt(value));
                break;
            }
            default: {
                System.err.println(String.format("%s has no attribute \"%s\"", this.getClass().getSimpleName(), name));
            }
        }
    }
}

