/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.ui.core;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Rect;

public abstract class Layout
extends Component {
    private final List<Component> children = new ArrayList<Component>();

    protected Layout(DisplayInfo display) {
        super(display);
    }

    @Override
    public void setBackground(Component bg) {
        super.setBackground(bg);
    }

    public void add(Component c) {
        this.children.add(c);
    }

    public void remove(Component c) {
        this.children.remove(c);
    }

    public void add(int i, Component c) {
        this.children.add(i, c);
    }

    public void remove(int i) {
        this.children.remove(i);
    }

    public void clear() {
        this.children.clear();
    }

    public int size() {
        return this.children.size();
    }

    public int indexOf(Component c) {
        return this.children.indexOf(c);
    }

    public void setChildAttribute(Component child, String name, String value) {
        System.err.println(String.format("%s has no attribute \"%s\"", this.getClass().getSimpleName(), name));
    }

    protected void forEach(Consumer<Component> consumer) {
        this.getChildren().stream().forEach(consumer);
    }

    public List<Component> getChildren() {
        return this.children;
    }

    @Override
    protected void draw(int x, int y, int width, int height) {
        Rect clip = this.getDisplay().getClipRect();
        this.getDisplay().setClipRect(new Rect(x, y, width, height).clip(clip));
        this.forEach(c -> c.callDraw());
        this.getDisplay().setClipRect(clip);
    }

    @Override
    protected int preferredWidth() {
        return this.children.stream().mapToInt(c -> c.getPreferredWidth()).max().orElse(0);
    }

    @Override
    protected int preferredHeight() {
        return this.children.stream().mapToInt(c -> c.getPreferredHeight()).max().orElse(0);
    }

    @Override
    protected int preferredWidth(int maxWidth, int maxHeight) {
        return this.children.stream().mapToInt(c -> c.getPreferredWidth(maxWidth, maxHeight)).max().orElse(0);
    }

    @Override
    protected int preferredHeight(int maxWidth, int maxHeight) {
        return this.children.stream().mapToInt(c -> c.getPreferredHeight(maxWidth, maxHeight)).max().orElse(0);
    }

    @Override
    public final Component getComponentByName(String name) {
        Component rtn = super.getComponentByName(name);
        if (rtn != null) {
            return rtn;
        }
        return this.children.stream().map(c -> c.getComponentByName(name)).filter(c -> c != null).findFirst().orElse(null);
    }

    @Override
    public final Component getComponentByPosition(int x, int y, Function<Component, Boolean> filter) {
        if (!this.isInDrawingRect(x, y)) {
            return null;
        }
        int i = this.children.size() - 1;
        while (i >= 0) {
            Component c = this.children.get(i).getComponentByPosition(x, y, filter);
            if (c != null) {
                return c;
            }
            --i;
        }
        if (filter == null || filter.apply(this).booleanValue()) {
            return this;
        }
        return null;
    }

    @Override
    public boolean scroll(int scrollX, int scrollY, int mouseX, int mouseY) {
        if (!this.isInDrawingRect(mouseX, mouseY)) {
            return false;
        }
        int i = this.children.size() - 1;
        while (i >= 0) {
            if (this.children.get(i).scroll(scrollX, scrollY, mouseX, mouseY)) {
                return true;
            }
            --i;
        }
        return false;
    }

    @Override
    public final void setRect(int x, int y, int width, int height) {
        super.setRect(x, y, width, height);
        this.layout(this.getContentRect().getX(), this.getContentRect().getY(), this.getContentRect().getWidth(), this.getContentRect().getHeight());
    }

    protected void layout(int x, int y, int width, int height) {
        this.forEach(c -> c.setRect(x, y, width, height));
    }
}

