/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.ui.core;

import java.util.function.Function;
import java.util.function.Supplier;
import net.comp_lot.ui.core.ClickListener;
import net.comp_lot.ui.core.CursorType;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layoutable;
import net.comp_lot.ui.core.Rect;
import org.xml.sax.Attributes;

public abstract class Component
extends Layoutable {
    public static final Function<Component, Boolean> FILTER_NONE = c -> true;
    public static final Function<Component, Boolean> FILTER_CLICKABLE = c -> c.isClickable();
    public static final Function<Component, Boolean> FILTER_HINT = c -> c.hasHint();
    private String name;
    private final DisplayInfo display;
    private boolean visible = true;
    private boolean forceDraw = false;
    private boolean setClipRect = false;
    private Component background;
    private ClickListener clickListener;
    private int hintTimeMillis;
    private Supplier<Component> hintSupplier;

    protected Component(DisplayInfo display) {
        this.display = display;
    }

    protected void setBackground(Component bg) {
        this.background = bg;
    }

    public boolean isClickable() {
        return this.clickListener != null;
    }

    public void setClickListener(ClickListener listener) {
        this.clickListener = listener;
    }

    public ClickListener getClickListener() {
        return this.clickListener;
    }

    public final DisplayInfo getDisplay() {
        return this.display;
    }

    public Component getComponentByName(String name) {
        if (this.name != null && this.name.equals(name)) {
            return this;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public boolean isInDrawingRect(int x, int y) {
        return this.visible && this.getRect().contain(x, y);
    }

    public Component getComponentByPosition(int x, int y, Function<Component, Boolean> filter) {
        if ((filter == null || filter.apply(this).booleanValue()) && this.isInDrawingRect(x, y)) {
            return this;
        }
        return null;
    }

    public final Component getClickedComponent(int x, int y) {
        return this.getComponentByPosition(x, y, FILTER_CLICKABLE);
    }

    public void setHint(Supplier<Component> hintSupplier) {
        this.setHint(hintSupplier, 500);
    }

    public void setHint(Supplier<Component> hintSupplier, int hintTimeMillis) {
        this.hintTimeMillis = hintTimeMillis;
        this.hintSupplier = hintSupplier;
    }

    public boolean hasHint() {
        return this.hintSupplier != null;
    }

    public Component getHint(long hoverMillis) {
        if (hoverMillis >= (long)this.hintTimeMillis) {
            return this.hintSupplier.get();
        }
        return null;
    }

    public boolean scroll(int scrollX, int scrollY, int mouseX, int mouseY) {
        return false;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setForceDraw(boolean forceDraw) {
        this.setForceDraw(forceDraw, forceDraw);
    }

    public void setForceDraw(boolean forceDraw, boolean setClipRect) {
        this.forceDraw = forceDraw;
        this.setClipRect = setClipRect;
    }

    public final void setArrtibutes(Attributes attr) {
        int i = 0;
        while (i < attr.getLength()) {
            if (!attr.getQName(i).startsWith("parent-")) {
                this.setAttribute(attr.getQName(i), attr.getValue(i));
            }
            ++i;
        }
    }

    @Override
    public void setAttribute(String name, String value) {
        switch (name) {
            case "name": {
                this.setName(value);
                break;
            }
            case "visible": {
                this.setVisible(Boolean.parseBoolean(value));
                break;
            }
            default: {
                super.setAttribute(name, value);
            }
        }
    }

    public final void callDraw() {
        if (this.visible && (this.forceDraw || this.display.getClipRect().crossing(this.getRect()))) {
            Rect tmp = null;
            if (this.setClipRect) {
                tmp = this.display.getClipRect();
                this.display.setClipRect(this.getRect());
            }
            if (this.background != null) {
                this.background.setRect(this.getRect().getX(), this.getRect().getY(), this.getRect().getWidth(), this.getRect().getHeight());
                this.background.callDraw();
            }
            this.draw(this.getContentRect().getX(), this.getContentRect().getY(), this.getContentRect().getWidth(), this.getContentRect().getHeight());
            if (this.setClipRect) {
                this.display.setClipRect(tmp);
            }
        }
    }

    protected abstract void draw(int var1, int var2, int var3, int var4);

    public void onHoverEnter() {
    }

    public void onHoverExit() {
    }

    public CursorType getCursorType() {
        return this.isClickable() ? CursorType.CLICK : CursorType.NORMAL;
    }

    public final void onButton1Pressed(int x, int y) {
        Component c = this.getClickedComponent(x, y);
        if (c != null) {
            c.getClickListener().onButton1Pressed(x, y);
        }
    }

    public final void onButton1Released(int x, int y) {
        Component c = this.getClickedComponent(x, y);
        if (c != null) {
            c.getClickListener().onButton1Released(x, y);
        }
    }

    public final void onButton2Pressed(int x, int y) {
        Component c = this.getClickedComponent(x, y);
        if (c != null) {
            c.getClickListener().onButton2Pressed(x, y);
        }
    }

    public final void onButton2Released(int x, int y) {
        Component c = this.getClickedComponent(x, y);
        if (c != null) {
            c.getClickListener().onButton2Released(x, y);
        }
    }

    public final void onButton3Pressed(int x, int y) {
        Component c = this.getClickedComponent(x, y);
        if (c != null) {
            c.getClickListener().onButton3Pressed(x, y);
        }
    }

    public final void onButton3Released(int x, int y) {
        Component c = this.getClickedComponent(x, y);
        if (c != null) {
            c.getClickListener().onButton3Released(x, y);
        }
    }

    public final void onButton4Pressed(int x, int y) {
        Component c = this.getClickedComponent(x, y);
        if (c != null) {
            c.getClickListener().onButton4Pressed(x, y);
        }
    }

    public final void onButton4Released(int x, int y) {
        Component c = this.getClickedComponent(x, y);
        if (c != null) {
            c.getClickListener().onButton4Released(x, y);
        }
    }

    public final void onButton5Pressed(int x, int y) {
        Component c = this.getClickedComponent(x, y);
        if (c != null) {
            c.getClickListener().onButton5Pressed(x, y);
        }
    }

    public final void onButton5Released(int x, int y) {
        Component c = this.getClickedComponent(x, y);
        if (c != null) {
            c.getClickListener().onButton5Released(x, y);
        }
    }

    public static int parseColor(String str) {
        if (str.startsWith("#")) {
            if ((str = str.substring(1)).length() == 6) {
                return Integer.parseInt(str, 16) << 8 | 0xFF;
            }
            if (str.length() == 8) {
                return Integer.parseInt(str.substring(0, 6), 16) << 8 | Integer.parseInt(str.substring(6), 16);
            }
        }
        try {
            throw new IllegalArgumentException("unknown color : " + str);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return -16711681;
        }
    }
}

