/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.ui;

import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.system.Game;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;
import net.comp_lot.ui.core.Rect;
import net.comp_lot.ui.layout.AbsoluteLayout;
import net.comp_lot.ui.layout.FrameLayout;

public class UIDisplay
extends DisplayInfo {
    private int width = 1000;
    private int height = 1000;
    private final ModelGroup mh = new ModelGroup();
    private final Layout root = new FrameLayout(this);
    private final Layout base = new FrameLayout(this);
    private final AbsoluteLayout overlay = new AbsoluteLayout(this);
    private final Game context;

    public UIDisplay(Game context) {
        this.context = context;
        this.root.add(this.base);
        this.root.add(this.overlay);
    }

    public Game getContext() {
        return this.context;
    }

    public Layout getRootLayout() {
        return this.root;
    }

    public Layout getBaseLayout() {
        return this.base;
    }

    public AbsoluteLayout getOverlayLayout() {
        return this.overlay;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.setClipRect(new Rect(0, 0, width, height));
    }

    public void draw() {
        this.mh.clearChildren();
        this.root.setRect(0, 0, this.getWidth(), this.getHeight());
        this.root.callDraw();
        this.mh.callConfirmCoordinate();
    }

    public void draw(Model m) {
        this.mh.addModels(m);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public double getScale() {
        return this.context.getConfig().getUiScale();
    }

    public ModelGroup getModel() {
        return this.mh;
    }
}

