/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.ui;

import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.model.Shape;
import net.comp_lot.glui.model.model.PolygonShape;
import net.comp_lot.glui.system.utils.TextureLoader;
import net.comp_lot.glui.ui.Background;
import net.comp_lot.glui.ui.UIColor;
import net.comp_lot.glui.ui.UIDisplay;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Rect;

public class TriangleBackground
extends Component {
    private int width = -1;
    private int height = -1;
    private Rect rect;
    private Shape triangle;
    private final Background square;
    private final int color;
    private final double aspect;

    public TriangleBackground(DisplayInfo display, int color, double aspect) {
        super(display);
        this.color = color;
        this.aspect = aspect;
        this.square = new Background(display, color);
    }

    public TriangleBackground(DisplayInfo display, int color, double aspect, int strokeColor, int strokeWidth) {
        this(display, color, aspect);
        if (strokeWidth > 0) {
            this.setPadding(strokeWidth);
            this.setBackground(new TriangleBackground(display, strokeColor, aspect));
        }
    }

    public TriangleBackground(DisplayInfo display, UIColor color, double aspect, UIColor strokeColor, int strokeWidth) {
        this(display, color.code(), aspect, strokeColor.code(), strokeWidth);
    }

    @Override
    protected int preferredWidth() {
        return 0;
    }

    @Override
    protected int preferredHeight() {
        return 0;
    }

    @Override
    protected void draw(int x, int y, int width, int height) {
        Rect rect = this.getDisplay().getClipRect().clip(new Rect(x, y, width, height));
        int edgeWidth = (int)((double)height * this.aspect);
        Rect squareRect = this.getDisplay().getClipRect().clip(new Rect(x, y, width - edgeWidth, height));
        this.square.draw(squareRect.getX(), squareRect.getY(), squareRect.getWidth(), squareRect.getHeight());
        if (!rect.equals(this.rect)) {
            this.rect = rect;
            Rect triangleRect = this.getDisplay().getClipRect().clip(new Rect(x + (width - edgeWidth), y, edgeWidth, height));
            if (this.width != rect.getWidth() || this.height != rect.getHeight()) {
                this.width = rect.getWidth();
                this.height = rect.getHeight();
                this.triangle = new PolygonShape(triangleRect.getWidth(), triangleRect.getHeight(), TextureLoader.PLAIN_INFO);
                this.triangle.setOpaque(false);
                this.triangle.setColor(this.color);
            }
            this.triangle.moveToP(new MutVector().set(triangleRect.getX(), -triangleRect.getY(), 0.0));
        }
        ((UIDisplay)this.getDisplay()).draw(this.triangle);
    }
}

