/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.ui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.comp_lot.glui.system.GameMode;
import net.comp_lot.glui.system.OperationEvent;
import net.comp_lot.glui.ui.InteractiveComponent;
import net.comp_lot.glui.ui.Label;
import net.comp_lot.glui.ui.UIDisplay;
import net.comp_lot.ui.core.ClickListener;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.Layout;
import net.comp_lot.ui.layout.VerticalLinearLayout;

public class TextInput
implements InteractiveComponent {
    private static final int COLOR_CANDIDATES = -1;
    private static final int COLOR_CANDIDATES_TEXT = 255;
    private static final int COLOR_CANDIDATES_SELECTED = 0x444466FF;
    private static final int COLOR_CANDIDATES_TEXT_SELECTED = -1;
    private static final int MAX_CANDIDATES = 7;
    private boolean enable = true;
    private final Label label;
    private int cursor = -1;
    private Runnable closeFunc;
    private Runnable confirmFunc;
    private Runnable backFunc;
    private String s = "";
    private Function<String, List<String>> candidatesFunction;
    private Layout candidatesFrame;
    private List<Label> candidatesLabels;
    private Label moreLabel;
    private int candidatesIndex = -1;
    private boolean candidateSelected = false;

    public TextInput(Label label) {
        this.label = label;
    }

    public TextInput(Label label, Runnable closeFunc) {
        this(label);
        this.setCloseFunc(closeFunc);
    }

    @Override
    public void frame(GameMode mode) {
        this.candidatesFrame(mode);
        if (!this.enable) {
            return;
        }
        if (mode.getKeyDownIgnoreMenu(OperationEvent.KeyCode.KEY_ENTER) || this.candidateSelected) {
            if (this.confirmFunc != null) {
                this.confirmFunc.run();
            }
            mode.setActiveComponent(null);
            return;
        }
        if (!(!mode.getKeyDownIgnoreMenu(OperationEvent.KeyCode.MOUSE_LEFT) || this.getLabel().isInDrawingRect(mode.getMouseX(), mode.getMouseY()) || this.isCandidatesEnable() && this.candidatesFrame.isInDrawingRect(mode.getMouseX(), mode.getMouseY()))) {
            mode.setActiveComponent(null);
            return;
        }
        if (mode.getKeyStateIgnoreMenu(OperationEvent.KeyCode.KEY_LEFT_CONTROL) || mode.getKeyStateIgnoreMenu(OperationEvent.KeyCode.KEY_RIGHT_CONTROL)) {
            if (mode.getKeyDownIgnoreMenu(OperationEvent.KeyCode.KEY_V)) {
                this.paste();
            }
            return;
        }
        Object s = this.getText();
        if (mode.getKeyStateIgnoreMenu(OperationEvent.KeyCode.MOUSE_LEFT)) {
            this.cursor = this.getLabel().getCursorPos(mode.getMouseX(), mode.getMouseY());
        }
        if (mode.getKeyDownRepeatIgnoreMenu(OperationEvent.KeyCode.KEY_RIGHT)) {
            ++this.cursor;
        }
        if (mode.getKeyDownRepeatIgnoreMenu(OperationEvent.KeyCode.KEY_LEFT)) {
            --this.cursor;
        }
        if (mode.getKeyDownIgnoreMenu(OperationEvent.KeyCode.KEY_HOME)) {
            this.cursor = 0;
        }
        if (mode.getKeyDownIgnoreMenu(OperationEvent.KeyCode.KEY_END)) {
            this.cursor = ((String)s).length();
        }
        this.cursor = Math.max(0, Math.min(((String)s).length(), this.cursor));
        Integer unicode = mode.pollChar();
        while (unicode != null) {
            s = ((String)s).substring(0, this.cursor) + Character.toChars(unicode)[0] + ((String)s).substring(this.cursor);
            ++this.cursor;
            unicode = mode.pollChar();
        }
        if (mode.getKeyDownRepeatIgnoreMenu(OperationEvent.KeyCode.KEY_BACKSPACE)) {
            if (this.cursor == 0) {
                if (this.backFunc != null) {
                    this.backFunc.run();
                }
            } else if (this.cursor > 0) {
                s = ((String)s).substring(0, this.cursor - 1) + ((String)s).substring(this.cursor);
                --this.cursor;
            }
        }
        if (mode.getKeyDownRepeatIgnoreMenu(OperationEvent.KeyCode.KEY_DELETE) && this.cursor < ((String)s).length()) {
            s = ((String)s).substring(0, this.cursor) + ((String)s).substring(this.cursor + 1);
        }
        if (!((String)s).equals(this.getText())) {
            this.setText((String)s);
        }
        this.updateCandidates();
        this.getLabel().setCursor(System.currentTimeMillis() % 1000L < 500L ? this.cursor : -1);
    }

    private void candidatesFrame(GameMode mode) {
        if (this.isCandidatesEnable()) {
            if (mode.getKeyDownIgnoreMenu(OperationEvent.KeyCode.KEY_ENTER) && this.candidatesIndex >= 0) {
                Label c = this.candidatesLabels.get(this.candidatesIndex);
                this.setText(c.getText());
            }
            this.scrollCandidates(mode.getKeyDownRepeatIgnoreMenu(OperationEvent.KeyCode.KEY_UP), mode.getKeyDownRepeatIgnoreMenu(OperationEvent.KeyCode.KEY_DOWN));
        }
    }

    private void scrollCandidates(boolean scrollUp, boolean scrollDown) {
        int oldIndex = this.candidatesIndex--;
        if (scrollUp && this.candidatesIndex < 0) {
            this.candidatesIndex = this.candidatesLabels.size() - 1;
        }
        if (scrollDown) {
            ++this.candidatesIndex;
            if (this.candidatesIndex >= this.candidatesLabels.size()) {
                this.candidatesIndex = 0;
            }
        }
        if (oldIndex != this.candidatesIndex) {
            Label c;
            if (oldIndex >= 0) {
                c = this.candidatesLabels.get(oldIndex);
                c.setBackground(-1);
                c.setColor(255);
            }
            c = this.candidatesLabels.get(this.candidatesIndex);
            c.setBackground(0x444466FF);
            c.setColor(-1);
        }
    }

    private void updateCandidates() {
        if (this.isCandidatesEnable()) {
            UIDisplay display = (UIDisplay)this.getLabel().getDisplay();
            if (this.candidatesFrame == null) {
                this.candidatesFrame = new VerticalLinearLayout(display){

                    @Override
                    public boolean scroll(int scrollX, int scrollY, int mouseX, int mouseY) {
                        if (!this.isInDrawingRect(mouseX, mouseY)) {
                            return false;
                        }
                        TextInput.this.scrollCandidates(scrollY > 0, scrollY < 0);
                        return true;
                    }
                };
                display.getOverlayLayout().add(this.candidatesFrame);
            }
            if (this.s != this.getText() || this.candidatesLabels == null) {
                this.s = this.getText();
                this.makeCandidates(display);
                this.candidatesIndex = -1;
            }
            this.candidatesFrame.clear();
            if (this.candidatesLabels.size() <= 7) {
                this.candidatesLabels.stream().forEach(l -> this.candidatesFrame.add((Component)l));
            } else {
                if (this.candidatesIndex < 6) {
                    this.candidatesLabels.stream().limit(7L).forEach(l -> this.candidatesFrame.add((Component)l));
                } else if (this.candidatesIndex < this.candidatesLabels.size() - 1) {
                    this.candidatesLabels.stream().skip(this.candidatesIndex - 7 + 2).limit(7L).forEach(l -> this.candidatesFrame.add((Component)l));
                } else {
                    this.candidatesLabels.stream().skip(this.candidatesLabels.size() - 7).forEach(l -> this.candidatesFrame.add((Component)l));
                }
                this.candidatesFrame.add(this.moreLabel);
            }
            display.getOverlayLayout().setPlace(this.candidatesFrame, this.getLabel().getRect().getX(), this.getLabel().getRect().getY() + this.getLabel().getRect().getHeight());
        }
    }

    private void makeCandidates(UIDisplay display) {
        this.candidatesLabels = this.candidatesFunction.apply(this.s).stream().map(c -> {
            Label label = new Label(display, this.getLabel().getFontSize(), (String)c);
            label.setPadding(4);
            label.setHorizontalMargin(0);
            label.setBackground(-1);
            label.setColor(255);
            label.setClickListener(new ClickListener().setOnButton1Pressed((x, y) -> {
                this.setText((String)c);
                this.candidateSelected = true;
            }));
            return label;
        }).collect(Collectors.toList());
        this.moreLabel = new Label(display, this.getLabel().getFontSize(), "\u2026");
        this.moreLabel.setAlign(Label.Align.RIGHT);
        this.moreLabel.setPadding(4);
        this.moreLabel.setHorizontalMargin(0);
        this.moreLabel.setBackground(-1);
        this.moreLabel.setColor(255);
        this.candidatesFrame.setMinWidth(this.candidatesLabels.stream().mapToInt(l -> l.getPreferredWidth()).max().orElseGet(() -> 0));
    }

    public void enableCandidates(Function<String, List<String>> function) {
        this.candidatesFunction = function;
    }

    private boolean isCandidatesEnable() {
        return this.candidatesFunction != null;
    }

    private void paste() {
        try {
            Toolkit kit = Toolkit.getDefaultToolkit();
            Clipboard clip = kit.getSystemClipboard();
            String str = (String)clip.getData(DataFlavor.stringFlavor);
            String s = this.getText();
            this.setText(s.substring(0, this.cursor) + str + s.substring(this.cursor));
            this.cursor += str.length();
        }
        catch (UnsupportedFlavorException | IOException exception) {
            // empty catch block
        }
    }

    protected void setText(String s) {
        this.getLabel().setText(s);
    }

    protected String getText() {
        return this.getLabel().getText();
    }

    public void setCursor(int cursor) {
        this.cursor = cursor = Math.max(0, Math.min(this.getText().length(), cursor));
    }

    public int getCursor() {
        return this.cursor;
    }

    public void setCloseFunc(Runnable closeFunc) {
        this.closeFunc = closeFunc;
    }

    public void setConfirmFunc(Runnable confirmFunc) {
        this.confirmFunc = confirmFunc;
    }

    public void setBackFunc(Runnable backFunc) {
        this.backFunc = backFunc;
    }

    @Override
    public void deactivate() {
        this.enable = false;
        if (this.isCandidatesEnable()) {
            UIDisplay display = (UIDisplay)this.getLabel().getDisplay();
            display.getOverlayLayout().remove(this.candidatesFrame);
        }
        if (this.closeFunc != null) {
            this.closeFunc.run();
        }
        this.getLabel().setCursor(-1);
    }

    public Label getLabel() {
        return this.label;
    }
}

