/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.ui;

import java.util.function.Consumer;
import net.comp_lot.glui.system.GameMode;
import net.comp_lot.glui.system.OperationEvent;
import net.comp_lot.glui.ui.Background;
import net.comp_lot.glui.ui.InteractiveComponent;
import net.comp_lot.glui.ui.UIColor;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.layout.AbsoluteLayout;

public class Slider
extends Component
implements InteractiveComponent {
    private final AbsoluteLayout layout;
    private final Component slider;
    private Runnable closeFunc;
    private Consumer<Double> changeFunc;
    private double pos = 0.0;

    public Slider(DisplayInfo display) {
        this(display, new Background(display, UIColor.GRAY, UIColor.NONE, 0), new Background(display, UIColor.ASH, UIColor.NONE, 0));
    }

    public Slider(DisplayInfo display, Component line, Component slider) {
        super(display);
        this.layout = new AbsoluteLayout(display);
        line.setMarginTop(8);
        line.setMarginBottom(8);
        this.layout.setBackground(line);
        this.slider = slider;
        slider.setMinWidth(24);
        slider.setMinHeight(24);
        this.layout.add(slider);
    }

    public Slider(DisplayInfo display, Runnable closeFunc) {
        this(display);
        this.setCloseFunc(closeFunc);
    }

    public void setPixelPos(int pos) {
        this.setPos((double)(pos -= this.getRect().getX() + this.slider.getPreferredWidth() / 2) / (double)(this.getRect().getWidth() - this.slider.getPreferredWidth()));
    }

    public void setPos(double pos) {
        this.pos = Math.max(0.0, Math.min(pos, 1.0));
        if (this.changeFunc != null) {
            this.changeFunc.accept(this.pos);
        }
    }

    public double getPos() {
        return this.pos;
    }

    @Override
    protected int preferredWidth() {
        return this.layout.getPreferredWidth();
    }

    @Override
    protected int preferredHeight() {
        return this.layout.getPreferredHeight();
    }

    @Override
    protected void draw(int x, int y, int width, int height) {
        this.layout.setPlace(this.slider, (int)((double)(width - this.slider.getPreferredWidth()) * this.pos), 0);
        this.layout.setRect(x, y, width, height);
        this.layout.callDraw();
    }

    @Override
    public void frame(GameMode mode) {
        if (mode.getKeyState(OperationEvent.KeyCode.MOUSE_LEFT)) {
            this.setPixelPos(mode.getMouseX());
        } else {
            mode.setActiveComponent(null);
        }
    }

    public void setChangeFunc(Consumer<Double> changeFunc) {
        this.changeFunc = changeFunc;
    }

    public void setCloseFunc(Runnable closeFunc) {
        this.closeFunc = closeFunc;
    }

    @Override
    public void deactivate() {
        if (this.closeFunc != null) {
            this.closeFunc.run();
        }
    }
}

