/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.ui;

import net.comp_lot.glui.model.TextureInfo;
import net.comp_lot.glui.ui.Image;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.layout.AlignmentLayout;

public class NineSliceImage
extends Component {
    private final AlignmentLayout layout;
    private final Image[][] images;

    public NineSliceImage(DisplayInfo display, TextureInfo tex, int cornerWidth, int color) {
        this(display, tex, cornerWidth);
        this.setColor(color);
    }

    public NineSliceImage(DisplayInfo display, TextureInfo tex, int cornerWidth) {
        super(display);
        this.layout = new AlignmentLayout(display);
        int uw = tex.getWidth() / 8;
        int uh = tex.getWidth() / 8;
        this.images = new Image[][]{{new Image(display, tex.getTex(), tex.getX() + uw * 0, tex.getY() + uh * 0, uw * 3, uh * 3), new Image(display, tex.getTex(), tex.getX() + uw * 3, tex.getY() + uh * 0, uw * 2, uh * 3), new Image(display, tex.getTex(), tex.getX() + uw * 5, tex.getY() + uh * 0, uw * 3, uh * 3)}, {new Image(display, tex.getTex(), tex.getX() + uw * 0, tex.getY() + uh * 3, uw * 3, uh * 2), new Image(display, tex.getTex(), tex.getX() + uw * 3, tex.getY() + uh * 3, uw * 2, uh * 2), new Image(display, tex.getTex(), tex.getX() + uw * 5, tex.getY() + uh * 3, uw * 3, uh * 2)}, {new Image(display, tex.getTex(), tex.getX() + uw * 0, tex.getY() + uh * 5, uw * 3, uh * 3), new Image(display, tex.getTex(), tex.getX() + uw * 3, tex.getY() + uh * 5, uw * 2, uh * 3), new Image(display, tex.getTex(), tex.getX() + uw * 5, tex.getY() + uh * 5, uw * 3, uh * 3)}};
        this.layout.add(this.images[0][0]);
        this.layout.add(this.images[0][2]);
        this.layout.add(this.images[2][0]);
        this.layout.add(this.images[2][2]);
        this.layout.add(this.images[0][1]);
        this.layout.add(this.images[2][1]);
        this.layout.add(this.images[1][0]);
        this.layout.add(this.images[1][2]);
        this.layout.add(this.images[1][1]);
        int x = 0;
        while (x < 3) {
            this.images[0][x].setHeight(cornerWidth);
            this.layout.setVerticalAlign(this.images[0][x], AlignmentLayout.VERTICAL_TOP);
            this.layout.setVerticalAlign(this.images[1][x], AlignmentLayout.verticalBetween(this.images[0][x], this.images[2][x]));
            this.images[2][x].setHeight(cornerWidth);
            this.layout.setVerticalAlign(this.images[2][x], AlignmentLayout.VERTICAL_BOTTOM);
            ++x;
        }
        int y = 0;
        while (y < 3) {
            this.images[y][0].setWidth(cornerWidth);
            this.layout.setHorizontalAlign(this.images[y][0], AlignmentLayout.HORIZONTAL_LEFT);
            this.layout.setHorizontalAlign(this.images[y][1], AlignmentLayout.horizontalBetween(this.images[y][0], this.images[y][2]));
            this.images[y][2].setWidth(cornerWidth);
            this.layout.setHorizontalAlign(this.images[y][2], AlignmentLayout.HORIZONTAL_RIGHT);
            ++y;
        }
    }

    public void setColor(int color) {
        int x = 0;
        while (x < 3) {
            int y = 0;
            while (y < 3) {
                this.images[y][x].setColor(color);
                ++y;
            }
            ++x;
        }
    }

    @Override
    protected int preferredWidth() {
        return 0;
    }

    @Override
    protected int preferredHeight() {
        return 0;
    }

    @Override
    protected void draw(int x, int y, int width, int height) {
        this.layout.setRect(x, y, width, height);
        this.layout.callDraw();
    }
}

