/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.ui;

import net.comp_lot.glui.ui.AngledLine;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.layout.AbsoluteLayout;

public class MultiLineComponent
extends Component {
    private final AbsoluteLayout layout;
    private final int defaultColor;

    public MultiLineComponent(DisplayInfo display, int defaultColor) {
        super(display);
        this.layout = new AbsoluteLayout(display);
        this.defaultColor = defaultColor;
    }

    public void clear() {
        this.layout.clear();
    }

    public void addLine(double ax, double ay, double bx, double by) {
        this.addLine(ax, ay, bx, by, this.defaultColor);
    }

    public void addLine(double ax, double ay, double bx, double by, int color) {
        if (ay > by) {
            this.addLine(bx, by, ax, ay, color);
            return;
        }
        AngledLine line = new AngledLine(this.getDisplay(), color);
        this.layout.add(line);
        line.setHeight((int)(by - ay));
        if (ax < bx) {
            line.setWidth((int)(bx - ax));
            line.setLeftTop(true);
            this.layout.setPlace(line, (int)ax, (int)ay);
        } else {
            line.setWidth((int)(ax - bx));
            line.setLeftTop(false);
            this.layout.setPlace(line, (int)bx, (int)ay);
        }
    }

    @Override
    protected int preferredWidth() {
        return 0;
    }

    @Override
    protected int preferredHeight() {
        return 0;
    }

    @Override
    protected void draw(int x, int y, int width, int height) {
        this.layout.setRect(x, y, width, height);
        this.layout.callDraw();
    }
}

