/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.ui;

import java.util.LinkedList;
import java.util.List;
import net.comp_lot.glui.ui.Label;
import net.comp_lot.glui.ui.UIColor;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;
import net.comp_lot.ui.layout.VerticalLinearLayout;

public class MessageBoard {
    private final DisplayInfo display;
    private final int fontSize;
    private final Layout layout;
    private final List<Message> list = new LinkedList<Message>();

    public void add(String message) {
        Message m = new Message(message, 5000);
        this.layout.add(m.label);
        this.list.add(m);
    }

    public void update() {
        while (!(this.list.isEmpty() || this.list.size() <= 15 && this.list.get(0).isEnable())) {
            this.layout.remove(this.list.remove((int)0).label);
        }
    }

    public MessageBoard(DisplayInfo display, int fontSize, int margin) {
        this.display = display;
        this.fontSize = fontSize;
        this.layout = new VerticalLinearLayout(display, margin);
    }

    public Component getComponent() {
        return this.layout;
    }

    private class Message {
        final Label label;
        final long time;

        Message(String message, int lifeTimeMillis) {
            this.label = new Label(MessageBoard.this.display, MessageBoard.this.fontSize);
            this.label.setBackground(UIColor.DARK_GRAY.code());
            this.label.setText(message);
            this.time = System.currentTimeMillis() + (long)lifeTimeMillis;
        }

        boolean isEnable() {
            return this.time > System.currentTimeMillis();
        }
    }
}

