/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.ui;

import java.util.Optional;
import net.comp_lot.glui.ui.Background;
import net.comp_lot.glui.ui.CharComponent;
import net.comp_lot.glui.ui.TriangleBackground;
import net.comp_lot.glui.ui.UIColor;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.CursorType;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;
import net.comp_lot.ui.core.Rect;
import net.comp_lot.ui.layout.CenterLayout;
import net.comp_lot.ui.layout.GravityLeftLayout;
import net.comp_lot.ui.layout.GravityRightLayout;
import net.comp_lot.ui.layout.GridLayout;

public class Label
extends Component {
    private int fontSize;
    private int color = -1;
    private int backgroundColor = 0;
    private int strokeColor = 0;
    private int strokeWidth = 0;
    private String text = "-";
    private Layout layout;
    private final GridLayout chars;
    private int prefWidth;
    private int prefHeight;
    private int cursorIndex = -1;
    private final Cursor cursor;
    private Corner corner = Corner.NONE;

    public Label(DisplayInfo display) {
        this(display, 30);
    }

    public Label(DisplayInfo display, int fontSize) {
        this(display, fontSize, "");
    }

    public Label(DisplayInfo display, int fontSize, String text) {
        super(display);
        this.chars = new GridLayout(display);
        this.setAlign(Align.LEFT);
        this.fontSize = fontSize;
        this.chars.setMinHeight((int)((double)fontSize * this.getDisplay().getScale()));
        this.cursor = new Cursor(display);
        if (text.equals(this.text)) {
            this.setText("");
        }
        this.setText(text);
        this.setPadding(fontSize / 8);
    }

    public void setCorner(Corner corner, int paddingRight) {
        this.corner = corner;
        this.setPaddingRight((int)(corner == Corner.NONE ? (double)paddingRight : (double)paddingRight + (double)this.fontSize * 0.25));
    }

    public void clearBackground() {
        super.setBackground(null);
    }

    @Deprecated
    public void setBackground(UIColor color) {
        this.setBackground(color.code());
    }

    public void setBackground(int color) {
        this.backgroundColor = color;
        this.updateBackground();
    }

    private void updateBackground() {
        if ((this.backgroundColor & 0xFF) == 0 && ((this.strokeColor & 0xFF) == 0 || this.strokeWidth == 0)) {
            super.setBackground(null);
        } else if (this.corner == Corner.NONE) {
            this.setBackground(new Background(this.getDisplay(), this.backgroundColor, this.strokeColor, this.strokeWidth));
        } else {
            this.setBackground(new TriangleBackground(this.getDisplay(), this.backgroundColor, 0.25, this.strokeColor, this.strokeWidth));
        }
    }

    public void setStrokeColor(int color) {
        this.strokeColor = color;
        this.updateBackground();
    }

    public void setStrokeWidth(int width) {
        this.strokeWidth = width;
        this.updateBackground();
    }

    public void setAlign(Align align) {
        if (align == Align.LEFT) {
            this.layout = new GravityLeftLayout(this.getDisplay(), this.chars);
        }
        if (align == Align.RIGHT) {
            this.layout = new GravityRightLayout(this.getDisplay(), this.chars);
        }
        if (align == Align.CENTER) {
            this.layout = new CenterLayout(this.getDisplay(), this.chars);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (!this.text.equals(text)) {
            this.text = text;
            this.updateText();
        }
    }

    private void updateText() {
        this.chars.clear();
        char[] cArray = this.text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '\n') {
                this.chars.add(this.chars.getLineSeparator());
            } else {
                this.chars.add(new CharComponent(this.getDisplay(), this.fontSize, this.color, c));
            }
            ++n2;
        }
        this.chachePrefSize();
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        this.chars.setMinHeight((int)((double)fontSize * this.getDisplay().getScale()));
        this.updateText();
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setColor(int color) {
        if (this.color != color) {
            this.color = color;
            this.updateText();
            this.cursor.setColor(color);
        }
    }

    public void setHorizontalMargin(int margin) {
        this.chars.setHorizontalMargin(margin);
        this.chachePrefSize();
    }

    public void setVerticalMargin(int margin) {
        this.chars.setVerticalMargin(margin);
        this.chachePrefSize();
    }

    @Override
    public CursorType getCursorType() {
        return this.isClickable() ? CursorType.TEXT : CursorType.NORMAL;
    }

    @Override
    public void setAttribute(String name, String value) {
        switch (name) {
            case "text": {
                this.setText(value);
                break;
            }
            case "font-size": {
                this.setFontSize(Integer.parseInt(value));
                break;
            }
            case "color": {
                this.setColor(Label.parseColor(value));
                break;
            }
            case "background-color": {
                this.setBackground(Label.parseColor(value));
                break;
            }
            case "align": {
                this.setAlign(Align.valueOf(value.toUpperCase()));
                break;
            }
            case "text-horizontal-margin": {
                this.setHorizontalMargin(Integer.parseInt(value));
                break;
            }
            case "text-vertical-margin": {
                this.setVerticalMargin(Integer.parseInt(value));
                break;
            }
            default: {
                super.setAttribute(name, value);
            }
        }
    }

    private void chachePrefSize() {
        this.prefWidth = this.layout.getPreferredWidth() + 1;
        this.prefHeight = this.layout.getPreferredHeight();
    }

    @Override
    protected int preferredWidth() {
        return this.prefWidth;
    }

    @Override
    protected int preferredHeight() {
        return this.prefHeight;
    }

    @Override
    protected int preferredWidth(int maxWidth, int maxHeight) {
        if (maxWidth >= this.prefWidth && maxHeight >= this.prefHeight) {
            return this.prefWidth;
        }
        return this.layout.getPreferredWidth(maxWidth, maxHeight) + 1;
    }

    @Override
    protected int preferredHeight(int maxWidth, int maxHeight) {
        if (maxWidth >= this.prefWidth && maxHeight >= this.prefHeight) {
            return this.prefHeight;
        }
        return this.layout.getPreferredHeight(maxWidth, maxHeight);
    }

    @Override
    protected void draw(int x, int y, int width, int height) {
        this.layout.setRect(x, y, width, height);
        this.layout.callDraw();
        this.cursorIndex = Math.min(this.cursorIndex, this.chars.getChildren().size());
        if (this.cursorIndex == 0) {
            Rect prev = this.chars.getRect();
            this.cursor.setRect(prev.getX(), prev.getY(), 1, this.chars.getMinHeight());
            this.cursor.callDraw();
        } else if (this.cursorIndex > 0) {
            Rect prev = this.chars.getChildren().get(this.cursorIndex - 1).getRect();
            this.cursor.setRect(prev.getX() + prev.getWidth(), prev.getY(), 1, prev.getHeight());
            this.cursor.callDraw();
        }
    }

    public void setCursor(int i) {
        this.cursorIndex = i;
    }

    public int getCursorPos(int x, int y) {
        Optional<Component> next = this.chars.getChildren().stream().filter(c -> x < c.getRect().getX() + c.getRect().getWidth() / 2 && y < c.getRect().getY() + c.getRect().getHeight()).findFirst();
        if (next.isEmpty()) {
            return this.text.length();
        }
        return this.chars.getChildren().indexOf(next.get());
    }

    public static enum Align {
        LEFT,
        RIGHT,
        CENTER;

    }

    public static enum Corner {
        NONE,
        TRIANGLE;

    }

    private class Cursor
    extends Component {
        protected Cursor(DisplayInfo display) {
            super(display);
            this.setColor(-1);
        }

        private void setColor(int color) {
            Background bg = new Background(this.getDisplay(), color);
            bg.setMarginTop((int)((double)Label.this.fontSize * this.getDisplay().getScale() / 8.0));
            bg.setMarginBottom((int)((double)Label.this.fontSize * this.getDisplay().getScale() / 8.0));
            this.setBackground(bg);
        }

        @Override
        protected int preferredWidth() {
            return 0;
        }

        @Override
        protected int preferredHeight() {
            return 0;
        }

        @Override
        protected void draw(int x, int y, int width, int height) {
        }
    }
}

