/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.ui;

import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.model.TextureInfo;
import net.comp_lot.glui.model.model.PlaneShape;
import net.comp_lot.glui.ui.UIDisplay;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Rect;

public class Image
extends Component {
    private int width = -1;
    private int height = -1;
    private int offsetX = -1;
    private int offsetY = -1;
    private Rect rect;
    private PlaneShape shape;
    private final int tex;
    private final float texX;
    private final float texY;
    private final float texW;
    private final float texH;
    private int unitWidth = Short.MAX_VALUE;
    private int unitHeight = Short.MAX_VALUE;
    private int color = -1;

    public Image(DisplayInfo display, int tex, float texX, float texY, float texW, float texH) {
        super(display);
        this.tex = tex;
        this.texX = texX;
        this.texY = texY;
        this.texW = texW;
        this.texH = texH;
    }

    public Image(DisplayInfo display, TextureInfo tex) {
        this(display, tex.getTex(), tex.getX(), tex.getY(), tex.getWidth(), tex.getHeight());
    }

    public void setRepeatUnit(int unitWidth, int unitHeight) {
        this.unitWidth = unitWidth;
        this.unitHeight = unitHeight;
    }

    public void setColor(int color) {
        this.color = color;
        this.shape = null;
    }

    @Override
    protected int preferredWidth() {
        return 0;
    }

    @Override
    protected int preferredHeight() {
        return 0;
    }

    @Override
    public void setAttribute(String name, String value) {
        switch (name) {
            case "color": {
                this.setColor(Image.parseColor(value));
                break;
            }
            default: {
                super.setAttribute(name, value);
            }
        }
    }

    @Override
    protected void draw(int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        Rect rect = new Rect(x, y, width, height);
        if (this.shape == null || !rect.equals(this.rect)) {
            this.rect = rect;
            Rect cliped = this.getDisplay().getClipRect().clip(rect);
            int offsetX = cliped.getX() - x;
            int offsetY = cliped.getY() - y;
            if (this.shape == null || this.width != cliped.getWidth() || this.height != cliped.getHeight() || this.offsetX != offsetX || this.offsetY != offsetY) {
                this.width = cliped.getWidth();
                this.height = cliped.getHeight();
                this.offsetX = offsetX;
                this.offsetY = offsetY;
                int texW = (int)(this.texW * (float)Math.max(width / this.unitWidth, 1));
                int texH = (int)(this.texH * (float)Math.max(height / this.unitHeight, 1));
                this.shape = new PlaneShape(cliped.getWidth(), cliped.getHeight(), this.texX + (float)(texW * this.offsetX / width), this.texY + (float)(texH * this.offsetY / height), texW * this.width / width, texH * this.height / height);
                this.shape.setOpaque(false);
                this.shape.setColor(this.color);
                this.shape.setTexture(this.tex);
            }
            this.shape.moveToP(new MutVector().set((double)cliped.getX() + 0.01, -((double)cliped.getY() + 0.01), 0.0));
        }
        ((UIDisplay)this.getDisplay()).draw(this.shape);
    }
}

