/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.ui;

import net.comp_lot.glui.model.TextureInfo;
import net.comp_lot.glui.sound.SoundEnum;
import net.comp_lot.glui.ui.Background;
import net.comp_lot.glui.ui.NineSliceImage;
import net.comp_lot.glui.ui.UIDisplay;
import net.comp_lot.ui.core.ClickListener;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;

public class ButtonLayout
extends Layout {
    private static final long TIME_PRESSED = 120L;
    private Runnable clickListener = () -> {};
    private Runnable hoverEnterListener = () -> {};
    private Runnable hoverExitListener = () -> {};
    private long lastClickedTime = 0L;
    private boolean enable = true;
    private boolean hover = false;
    private TextureInfo tex;
    private int cornerWidth;
    private Component baseBackground;
    private Component hoverBackground;
    private Component pressedBackground;
    private Component disableBackground;

    public ButtonLayout(DisplayInfo display) {
        this(display, null, 0);
    }

    public ButtonLayout(DisplayInfo display, Component child) {
        this(display);
        this.add(child);
    }

    public ButtonLayout(DisplayInfo display, TextureInfo tex, int cornerWidth) {
        super(display);
        this.setNineSlice(tex, cornerWidth);
        this.setEnable(true);
    }

    public void setNineSlice(TextureInfo tex, int cornerWidth) {
        this.tex = tex;
        this.cornerWidth = cornerWidth;
        this.setColors();
    }

    private void setColors() {
        this.setBaseColor(0x424242FF);
        this.setHoverColor(0x555555FF);
        this.setPressedColor(1249759231);
        this.setDisableColor(0x222222FF);
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
        if (enable) {
            this.setClickListener(new ClickListener().setOnButton1Pressed((x, y) -> {
                this.lastClickedTime = System.currentTimeMillis();
                ((UIDisplay)this.getDisplay()).getContext().getAudioSystem().playSound(SoundEnum.CLICK.getId(), ((UIDisplay)this.getDisplay()).getContext().getConfig().getVolumeUi(), false);
                this.clickListener.run();
            }));
        } else {
            this.setClickListener((ClickListener)null);
        }
    }

    public void setBaseColor(int color) {
        if (this.tex != null) {
            this.setBaseBackground(new NineSliceImage(this.getDisplay(), this.tex, this.cornerWidth, color));
        } else {
            this.setBaseBackground(new Background(this.getDisplay(), color));
        }
    }

    public void setHoverColor(int color) {
        if (this.tex != null) {
            this.setHoverBackground(new NineSliceImage(this.getDisplay(), this.tex, this.cornerWidth, color));
        } else {
            this.setHoverBackground(new Background(this.getDisplay(), color));
        }
    }

    public void setPressedColor(int color) {
        if (this.tex != null) {
            this.setPressedBackground(new NineSliceImage(this.getDisplay(), this.tex, this.cornerWidth, color));
        } else {
            this.setPressedBackground(new Background(this.getDisplay(), color));
        }
    }

    public void setDisableColor(int color) {
        if (this.tex != null) {
            this.setDisableBackground(new NineSliceImage(this.getDisplay(), this.tex, this.cornerWidth, color));
        } else {
            this.setDisableBackground(new Background(this.getDisplay(), color));
        }
    }

    public void setBaseBackground(Component bg) {
        this.baseBackground = bg;
    }

    public void setHoverBackground(Component bg) {
        this.hoverBackground = bg;
    }

    public void setPressedBackground(Component bg) {
        this.pressedBackground = bg;
    }

    public void setDisableBackground(Component bg) {
        this.disableBackground = bg;
    }

    @Override
    public void setAttribute(String name, String value) {
        switch (name) {
            case "base-color": {
                this.setBaseColor(ButtonLayout.parseColor(value));
                break;
            }
            case "hover-color": {
                this.setHoverColor(ButtonLayout.parseColor(value));
                break;
            }
            case "pressed-color": {
                this.setPressedColor(ButtonLayout.parseColor(value));
                break;
            }
            case "disable-color": {
                this.setDisableColor(ButtonLayout.parseColor(value));
                break;
            }
            case "enable": {
                this.setEnable(Boolean.parseBoolean(value));
                break;
            }
            case "nine-slice": {
                String[] tex = value.split(",");
                this.setNineSlice(new TextureInfo(Integer.parseInt(tex[0]), Integer.parseInt(tex[1]), Integer.parseInt(tex[2]), Integer.parseInt(tex[3]), Integer.parseInt(tex[4])), Integer.parseInt(tex[5]));
                break;
            }
            default: {
                super.setAttribute(name, value);
            }
        }
    }

    public void setClickListener(Runnable listener) {
        this.clickListener = listener;
    }

    public void setHoverEnterListener(Runnable listener) {
        this.hoverEnterListener = listener;
    }

    public void setHoverExitListener(Runnable listener) {
        this.hoverExitListener = listener;
    }

    @Override
    protected void layout(int x, int y, int width, int height) {
        if (this.lastClickedTime > 0L && System.currentTimeMillis() - this.lastClickedTime > 120L) {
            this.lastClickedTime = 0L;
        }
        if (this.enable) {
            if (this.lastClickedTime > 0L) {
                this.setBackground(this.pressedBackground);
            } else if (this.hover) {
                this.setBackground(this.hoverBackground);
            } else {
                this.setBackground(this.baseBackground);
            }
        } else {
            this.setBackground(this.disableBackground);
        }
        super.layout(x, y, width, height);
    }

    @Override
    public void onHoverEnter() {
        this.hover = true;
        this.hoverEnterListener.run();
    }

    @Override
    public void onHoverExit() {
        this.hover = false;
        this.hoverExitListener.run();
    }
}

