/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.ui;

import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.model.PlaneShape;
import net.comp_lot.glui.system.utils.TextureLoader;
import net.comp_lot.glui.ui.UIDisplay;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Rect;

public class AngledLine
extends Component {
    private int width = -1;
    private int height = -1;
    private int offsetX = -1;
    private int offsetY = -1;
    private PlaneShape shape;
    private float lineWidth = 1.0f;
    private boolean isLeftTop = true;
    private int color = -1;

    public AngledLine(DisplayInfo display, int color) {
        super(display);
        this.setColor(color);
    }

    public void setColor(int color) {
        this.color = color;
        this.shape = null;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
        this.shape = null;
    }

    public void setLeftTop(boolean isLeftTop) {
        this.isLeftTop = isLeftTop;
        this.shape = null;
    }

    @Override
    protected int preferredWidth() {
        return 0;
    }

    @Override
    protected int preferredHeight() {
        return 0;
    }

    @Override
    public void setAttribute(String name, String value) {
        switch (name) {
            case "color": {
                this.setColor(AngledLine.parseColor(value));
                break;
            }
            case "line-width": {
                this.setLineWidth(Float.parseFloat(value));
                break;
            }
            case "left-top": {
                this.setLeftTop(Boolean.parseBoolean(value));
                break;
            }
            default: {
                super.setAttribute(name, value);
            }
        }
    }

    @Override
    protected void draw(int x, int y, int width, int height) {
        Rect rect = this.getDisplay().getClipRect().clip(new Rect(x, y, width, height));
        int offsetLeft = rect.getX() - x;
        int offsetTop = rect.getY() - y;
        int offsetRight = x + width - (rect.getX() + rect.getWidth());
        int offsetBottom = y + height - (rect.getY() + rect.getHeight());
        if (this.isLeftTop) {
            if (height != 0) {
                offsetLeft = Math.max(offsetLeft, offsetTop * width / height);
                offsetRight = Math.max(offsetRight, offsetBottom * width / height);
            }
            if (width != 0) {
                offsetTop = Math.max(offsetTop, offsetLeft * height / width);
                offsetBottom = Math.max(offsetBottom, offsetRight * height / width);
            }
        } else {
            if (height != 0) {
                offsetRight = Math.max(offsetRight, offsetTop * width / height);
                offsetLeft = Math.max(offsetLeft, offsetBottom * width / height);
            }
            if (width != 0) {
                offsetTop = Math.max(offsetTop, offsetRight * height / width);
                offsetBottom = Math.max(offsetBottom, offsetLeft * height / width);
            }
        }
        if (offsetLeft + offsetRight > width || offsetTop + offsetBottom > height) {
            return;
        }
        rect = new Rect(x + offsetLeft, y + offsetTop, width - (offsetLeft + offsetRight), height - (offsetTop + offsetBottom));
        if (this.shape == null || this.width != rect.getWidth() || this.height != rect.getHeight() || this.offsetX != offsetLeft || this.offsetY != offsetTop) {
            this.width = rect.getWidth();
            this.height = rect.getHeight();
            this.offsetX = offsetLeft;
            this.offsetY = offsetTop;
            double lineLength = Math.sqrt(rect.getWidth() * rect.getWidth() + rect.getHeight() * rect.getHeight());
            this.shape = new PlaneShape(lineLength, this.lineWidth, TextureLoader.PLAIN_INFO);
            double angle = Math.atan2(rect.getHeight(), this.isLeftTop ? rect.getWidth() : -rect.getWidth());
            this.shape.rotateP(Vector.ZERO, new MutVector().set(0.0, 0.0, -1.0), angle);
            this.shape.setOpaque(false);
            this.shape.setColor(this.color);
        }
        this.shape.moveToP(new MutVector().set(this.isLeftTop ? rect.getX() : rect.getX() + rect.getWidth(), -rect.getY(), 0.0));
        ((UIDisplay)this.getDisplay()).draw(this.shape);
    }
}

