/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.test;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import net.comp_lot.glui.system.Game;
import net.comp_lot.glui.system.GameMode;
import net.comp_lot.glui.system.GluiApplication;
import net.comp_lot.glui.system.GluiConfig;
import net.comp_lot.glui.system.OperationEvent;
import net.comp_lot.glui.system.utils.FileUtils;
import net.comp_lot.glui.system.utils.GluiXMLLayoutParser;
import net.comp_lot.glui.system.utils.TextureLoader;
import net.comp_lot.glui.ui.Background;
import net.comp_lot.glui.ui.ButtonLayout;
import net.comp_lot.glui.ui.FrameBackground;
import net.comp_lot.glui.ui.Label;
import net.comp_lot.glui.ui.TextInput;
import net.comp_lot.ui.core.ClickListener;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;
import net.comp_lot.ui.core.Rect;
import net.comp_lot.ui.layout.AbsoluteLayout;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.nfd.NFDFilterItem;
import org.lwjgl.util.nfd.NativeFileDialog;

public class GluiLayoutEditer
extends GameMode {
    private static final int FONT_SIZE = 24;
    private final Layout frame;
    private final Layout textArea;
    private TextInput newInput;
    private final AbsoluteLayout overlayLayout;
    private final Component overlayComponent;
    private final Label overlayLabel;
    private File file;

    public static void main(String ... args) {
        GluiConfig config = new GluiConfig();
        new GluiApplication(config).setTitle("glui Layout Editer").setTexture(TextureLoader.load(new BufferedImage(1, 1, 6), config.getFontName())).setFirstMode(game -> new GluiLayoutEditer((Game)game)).launch();
    }

    public GluiLayoutEditer(Game game) {
        super(game, 60);
        Component layout = new GluiXMLLayoutParser().parseOrElse((DisplayInfo)this.uiDisplay, this.getClass().getResourceAsStream("editer_layout.xml"), () -> new Background((DisplayInfo)this.uiDisplay, -16711681));
        this.addUI(layout);
        this.textArea = (Layout)layout.getComponentByName("text-area");
        this.textArea.add(this.makeLine("<?xml version=\"1.0\" encoding=\"utf-8\"?>"));
        ((Layout)layout.getComponentByName("text-scroll")).setBackground(new Background((DisplayInfo)this.uiDisplay, -117901057));
        this.frame = (Layout)layout.getComponentByName("content-frame");
        this.frame.setBackground(new Background((DisplayInfo)this.uiDisplay, 0x8800FF));
        ButtonLayout openButton = (ButtonLayout)layout.getComponentByName("open-button");
        openButton.setClickListener(() -> {
            this.showFileDialog();
            this.openFile();
        });
        ButtonLayout reloadButton = (ButtonLayout)layout.getComponentByName("reload-button");
        reloadButton.setClickListener(() -> this.openFile());
        ButtonLayout updateButton = (ButtonLayout)layout.getComponentByName("update-button");
        updateButton.setClickListener(() -> this.update());
        ButtonLayout printButton = (ButtonLayout)layout.getComponentByName("print-button");
        printButton.setClickListener(() -> {
            StringBuilder sb = new StringBuilder();
            this.textArea.getChildren().stream().map(c -> ((Label)c).getText()).forEach(s -> {
                sb.append((String)s);
                sb.append("\n");
            });
            System.out.print(sb.toString());
        });
        Label widthBox = (Label)layout.getComponentByName("width-box");
        widthBox.setBackground(0x222222FF);
        widthBox.setClickListener(new ClickListener().setOnButton1Pressed((x, y) -> this.setActiveComponent(new TextInput(widthBox, () -> {
            int width = this.frame.getRect().getWidth();
            try {
                width = Integer.parseInt(widthBox.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            width = Math.max(1, Math.min(width, 10000));
            widthBox.setText(String.valueOf(width));
            this.frame.setWidth(width);
        }))));
        Label heightBox = (Label)layout.getComponentByName("height-box");
        heightBox.setBackground(0x222222FF);
        heightBox.setClickListener(new ClickListener().setOnButton1Pressed((x, y) -> this.setActiveComponent(new TextInput(heightBox, () -> {
            int height = this.frame.getRect().getHeight();
            try {
                height = Integer.parseInt(heightBox.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            height = Math.max(1, Math.min(height, 10000));
            heightBox.setText(String.valueOf(height));
            this.frame.setHeight(height);
        }))));
        this.overlayLayout = (AbsoluteLayout)layout.getComponentByName("overlay-layout");
        this.overlayComponent = new FrameBackground((DisplayInfo)this.uiDisplay, 2, -16776961);
        this.overlayLabel = new Label(this.uiDisplay, 24);
        this.overlayLabel.setBackground(136);
    }

    private void update() {
        this.frame.clear();
        try {
            StringBuilder sb = new StringBuilder();
            this.textArea.getChildren().stream().map(c -> ((Label)c).getText()).forEach(s -> {
                sb.append((String)s);
                sb.append("\n");
            });
            this.frame.add(new GluiXMLLayoutParser().parse((DisplayInfo)this.uiDisplay, sb.toString()));
        }
        catch (Exception e) {
            this.frame.add(new Label(this.uiDisplay, 24, e.getLocalizedMessage()));
        }
    }

    @Override
    protected void onFrame() {
        if (this.getKeyDown(OperationEvent.KeyCode.KEY_F5)) {
            this.update();
        }
        this.overlayLayout.clear();
        Component c = this.frame.getComponentByPosition(this.getMouseX(), this.getMouseY(), Component.FILTER_NONE);
        if (c != null && c != this.frame) {
            Rect rect = c.getRect();
            this.overlayLayout.add(this.overlayComponent);
            this.overlayLayout.setPlace(this.overlayComponent, rect.getX() - 1, rect.getY() - 1);
            this.overlayComponent.setWidth(rect.getWidth() + 2);
            this.overlayComponent.setHeight(rect.getHeight() + 2);
            this.overlayLabel.setText(String.format("%s \"%s\"", c.getClass().getSimpleName(), c.getName() != null ? c.getName() : "--"));
            this.overlayLayout.add(this.overlayLabel);
            this.overlayLayout.setPlace(this.overlayLabel, this.getMouseX() + 32, this.getMouseY());
        }
        if (this.newInput != null) {
            this.setActiveComponent(this.newInput);
            this.newInput = null;
        }
        this.mainModel.callConfirmCoordinate();
    }

    private void openFile() {
        if (this.file != null) {
            this.frame.clear();
            this.textArea.clear();
            try {
                String stageSrc = FileUtils.loadFromStream(new FileInputStream(this.file));
                stageSrc.lines().forEach(line -> this.textArea.add(this.makeLine((String)line)));
                this.frame.add(new GluiXMLLayoutParser().parse((DisplayInfo)this.uiDisplay, stageSrc));
            }
            catch (Exception e) {
                this.frame.add(new Label(this.uiDisplay, 24, e.getLocalizedMessage()));
            }
        }
    }

    private Label makeLine(String line) {
        Label label = new Label(this.uiDisplay, 24, line);
        label.setColor(255);
        label.setHorizontalMargin(1);
        label.setClickListener(new ClickListener().setOnButton1Pressed((x, y) -> {
            TextInput input = this.makeTextInput(label);
            this.setActiveComponent(input);
        }));
        return label;
    }

    private TextInput makeTextInput(Label label) {
        TextInput input = new TextInput(label);
        input.setConfirmFunc(() -> {
            String indent = label.getText().substring(0, label.getText().length() - label.getText().stripLeading().length());
            Label newLine = this.makeLine(indent + label.getText().substring(input.getCursor()));
            this.newInput = this.makeTextInput(newLine);
            this.newInput.setCursor(indent.length());
            label.setText(label.getText().substring(0, input.getCursor()));
            this.textArea.add(this.textArea.getChildren().indexOf(label) + 1, newLine);
        });
        input.setBackFunc(() -> {
            int i = this.textArea.getChildren().indexOf(label);
            if (i == 0) {
                return;
            }
            Label prevLine = (Label)this.textArea.getChildren().get(i - 1);
            this.newInput = this.makeTextInput(prevLine);
            this.newInput.setCursor(prevLine.getText().length());
            prevLine.setText(prevLine.getText() + label.getText());
            this.textArea.remove(i);
        });
        return input;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void showFileDialog() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MemoryStack stack = MemoryStack.stackPush();){
            NFDFilterItem.Buffer filter = NFDFilterItem.malloc(1);
            ((NFDFilterItem)filter.get(0)).name(stack.UTF8("XML layout")).spec(stack.UTF8("xml"));
            PointerBuffer p = stack.mallocPointer(1);
            int result = NativeFileDialog.NFD_OpenDialog(p, filter, null);
            switch (result) {
                case 1: {
                    this.file = new File(p.getStringUTF8());
                    NativeFileDialog.NFD_FreePath(p.get(0));
                    return;
                }
                case 2: {
                    return;
                }
                default: {
                    System.err.format("Error: %s\n", NativeFileDialog.NFD_GetError());
                    return;
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            } else {
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

