/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.system.utils;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import net.comp_lot.glui.model.TextureInfo;

public class TexturePacker {
    private static final int PADDING = 1;
    private final int size;
    private final Map<BufferedImage, TexturePlace> map = new HashMap<BufferedImage, TexturePlace>();

    public TexturePacker(int size) {
        this.size = size;
    }

    public TexturePlace add(BufferedImage img) {
        int j;
        TexturePlace place = new TexturePlace();
        BufferedImage eImg = new BufferedImage(img.getWidth() + 2, img.getHeight() + 2, 2);
        Graphics2D g = (Graphics2D)eImg.getGraphics();
        g.drawImage((Image)img, 1, 1, null);
        int i = 0;
        while (i < eImg.getHeight()) {
            j = 0;
            while (j < 1) {
                eImg.setRGB(j, i, eImg.getRGB(1, i));
                eImg.setRGB(eImg.getWidth() - 1 - j, i, eImg.getRGB(eImg.getWidth() - 1 - 1, i));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < eImg.getWidth()) {
            j = 0;
            while (j < 1) {
                eImg.setRGB(i, j, eImg.getRGB(i, 1));
                eImg.setRGB(i, eImg.getHeight() - 1 - j, eImg.getRGB(i, eImg.getHeight() - 1 - 1));
                ++j;
            }
            ++i;
        }
        this.map.put(eImg, place);
        return place;
    }

    public BufferedImage pack() {
        BufferedImage tex = new BufferedImage(this.size, this.size, 2);
        Graphics2D g = (Graphics2D)tex.getGraphics();
        g.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        g.clearRect(0, 0, this.size, this.size);
        this.pack(g, 0, 0, this.size, this.size);
        if (this.map.entrySet().stream().anyMatch(e -> ((TexturePlace)e.getValue()).x < 0)) {
            System.err.println("Failed to pack some image(s)");
        }
        return tex;
    }

    private void pack(Graphics2D g, int i, int j, int w, int h) {
        Map.Entry max = this.map.entrySet().stream().filter(e -> ((TexturePlace)e.getValue()).x < 0).filter(e -> ((BufferedImage)e.getKey()).getWidth() <= w && ((BufferedImage)e.getKey()).getHeight() <= h).max((a, b) -> Integer.compare(((BufferedImage)a.getKey()).getHeight() * 100000 + ((BufferedImage)a.getKey()).getWidth(), ((BufferedImage)b.getKey()).getHeight() * 100000 + ((BufferedImage)b.getKey()).getWidth())).orElse(null);
        if (max == null) {
            return;
        }
        BufferedImage img = (BufferedImage)max.getKey();
        g.drawImage((Image)img, i, j, null);
        TexturePlace place = (TexturePlace)max.getValue();
        place.x = i + 1;
        place.y = j + 1;
        place.w = img.getWidth() - 2;
        place.h = img.getHeight() - 2;
        this.pack(g, i + img.getWidth(), j, w - img.getWidth(), img.getHeight());
        this.pack(g, i, j + img.getHeight(), w, h - img.getHeight());
    }

    public static class TexturePlace {
        private int x = -1;
        private int y = -1;
        private int w = -1;
        private int h = -1;

        private TexturePlace() {
        }

        public int getLeftTopX() {
            return this.x;
        }

        public int getLeftTopY() {
            return this.y;
        }

        public int getWidth() {
            return this.w;
        }

        public int getHeight() {
            return this.h;
        }

        public TextureInfo toInfo(int tex) {
            return new TextureInfo(tex, this.x, this.y, this.w, this.h);
        }
    }
}

