/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.system.utils;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.comp_lot.glui.model.TextureInfo;
import net.comp_lot.glui.system.utils.FileUtils;
import net.comp_lot.glui.ui.FontInfo;

public class TextureLoader {
    public static final int SIZE = 8192;
    private static final int FONT_SIZE = 50;
    public static final TextureInfo PLAIN_INFO = new TextureInfo(1, 8190, 8190, 1, 1);
    private final int texSize;
    private static final Map<Character, FontInfo> MAP = new HashMap<Character, FontInfo>();

    public static BufferedImage load(BufferedImage tex, String fontName) {
        return new TextureLoader(tex.getWidth()).make(tex, fontName);
    }

    public TextureLoader(int texSize) {
        this.texSize = texSize;
    }

    private BufferedImage make(BufferedImage tex, String fontName) {
        Font font;
        BufferedImage image = new BufferedImage(8192, 8192, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        g.clearRect(0, 0, 8192, 8192);
        g.drawImage((Image)tex, 0, 0, null);
        if (fontName == null) {
            try {
                font = Font.createFont(0, this.getClass().getResourceAsStream("/glui/IBMPlexSansJP-SemiBold.ttf"));
            }
            catch (FontFormatException | IOException e) {
                e.printStackTrace();
                System.exit(1);
                return null;
            }
        } else {
            font = new Font(fontName, 0, 50);
        }
        this.writeFont(g, font);
        g.setColor(Color.WHITE);
        g.fillRect(8189, 8189, 3, 3);
        return image;
    }

    private void writeFont(Graphics2D g, Font font) {
        char[] chars;
        g.setColor(Color.decode("#fafafa"));
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int size = 50;
        while (size > 0) {
            g.setFont(font.deriveFont((float)size + 0.0f));
            if (g.getFontMetrics().getHeight() <= 50) break;
            --size;
        }
        int x = this.texSize;
        int y = 0;
        String s = FileUtils.loadFromStream(this.getClass().getResourceAsStream("/glui/jis90.txt")).replaceAll("\n", "");
        char[] cArray = chars = s.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            int w = g.getFontMetrics().stringWidth("" + c);
            if (++x + w > 8192) {
                x = (y += 51) < this.texSize ? this.texSize : 0;
            }
            MAP.put(Character.valueOf(c), new FontInfo(x, y, w, 50));
            g.drawString("" + c, x, y + g.getFontMetrics().getAscent());
            x += w;
            ++n2;
        }
        MAP.put(Character.valueOf('\t'), FontInfo.tabInfo(MAP.get(Character.valueOf(' '))));
    }

    public static FontInfo getInfo(char c) {
        return MAP.getOrDefault(Character.valueOf(c), MAP.get(Character.valueOf('\ufffd')));
    }
}

