/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.system.utils;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.model.Shape;
import net.comp_lot.glui.model.model.PlaneShape;
import net.comp_lot.glui.system.utils.FileUtils;

public class ObjWriter {
    private final StringBuilder sb = new StringBuilder();
    private int size = 0;
    private final Map<Vector, Integer> vertices = new LinkedHashMap<Vector, Integer>();

    public void add(Model m) {
        this.vertices.clear();
        this.sb.append("o Model\n");
        this.flatMap(m).flatMap((? super T s) -> Arrays.stream(s.getVertexGlobal())).forEach(v -> {
            if (!this.vertices.containsKey(v)) {
                this.vertices.put((Vector)v, ++this.size);
            }
        });
        this.vertices.keySet().stream().forEach(v -> {
            StringBuilder stringBuilder = this.sb.append(String.format("v %.3f %.3f %.3f\n", -v.getX(), v.getY(), v.getZ()));
        });
        this.flatMap(m).forEach(s -> {
            if (s instanceof PlaneShape) {
                this.sb.append(String.format("f %d %d %d %d\n", this.vertices.get(s.getVertexGlobal()[0]), this.vertices.get(s.getVertexGlobal()[1]), this.vertices.get(s.getVertexGlobal()[2]), this.vertices.get(s.getVertexGlobal()[3])));
            } else {
                Arrays.stream(s.getFacesArray()).forEach(f -> {
                    StringBuilder stringBuilder = this.sb.append(String.format("f %d %d %d\n", this.vertices.get(f.getA()), this.vertices.get(f.getB()), this.vertices.get(f.getC())));
                });
            }
        });
    }

    private Stream<Shape> flatMap(Model model) {
        if (model instanceof Shape) {
            return Stream.of((Shape)model);
        }
        return ((ModelGroup)model).getAllChildren().stream().flatMap((? super T m) -> this.flatMap((Model)m));
    }

    public void write(String path) {
        FileUtils.writeFile(path, this.sb.toString());
    }
}

