/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.system.utils;

import java.awt.Color;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.stream.Collectors;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.model.Shape;
import net.comp_lot.glui.model.TextureInfo;
import net.comp_lot.glui.model.model.PlaneShape;
import net.comp_lot.glui.model.model.PolygonShape;
import net.comp_lot.glui.system.utils.FileUtils;

public class ObjParser {
    private static final int DEFAULT_COLOR = -556086273;
    private final TextureInfo texture;
    private final String file;
    private final String src;
    private final List<Vector> points = new ArrayList<Vector>();
    private final List<Vector> normals = new ArrayList<Vector>();
    private final List<Vector> textures = new ArrayList<Vector>();
    private final Map<String, ModelGroup> groups = new HashMap<String, ModelGroup>();
    private final Map<String, Color> materials = new HashMap<String, Color>();
    private int mat = -556086273;
    private ModelGroup root;
    private ModelGroup group = this.root = new ModelGroup();

    public ObjParser(String file, TextureInfo texture) throws FileNotFoundException {
        this.file = file;
        this.texture = texture;
        this.src = FileUtils.loadFile(file);
        this.points.add(null);
        this.normals.add(null);
        this.textures.add(null);
        this.materials.put("None", Color.decode("#dedacb"));
        this.groups.put("_root", this.root);
        this.parse();
    }

    public ModelGroup getModel() {
        return this.root;
    }

    public ModelGroup getModel(String name) {
        return this.groups.get(name);
    }

    private void parse() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Scanner scan = new Scanner(this.src);){
            while (scan.hasNextLine()) {
                String line = scan.nextLine();
                if (line.startsWith("v ")) {
                    this.parseVector(line);
                    continue;
                }
                if (line.startsWith("vn ")) {
                    this.parseNormal(line);
                    continue;
                }
                if (line.startsWith("vt ")) {
                    this.parseTexture(line);
                    continue;
                }
                if (line.startsWith("f ")) {
                    this.parseFace(line);
                    continue;
                }
                if (line.startsWith("mtllib ")) {
                    this.parseMaterial(line);
                    continue;
                }
                if (line.startsWith("usemtl ")) {
                    this.selectMateial(line);
                    continue;
                }
                if (!line.startsWith("g ")) continue;
                this.selectGroup(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.root.callConfirmCoordinate();
        this.root.setBound();
    }

    private void selectGroup(String g) {
        if (!this.groups.containsKey(g = g.substring(2, g.lastIndexOf("_")))) {
            this.group = new ModelGroup();
            this.groups.put(g, this.group);
            this.root.addModels(this.group);
        } else {
            this.group = this.groups.get(g);
        }
    }

    private void selectMateial(String m) {
        if (this.materials.containsKey(m = m.substring(7))) {
            Color c = this.materials.get(m);
            this.mat = c.getRGB() << 8 | c.getAlpha();
        } else {
            System.err.println("Material \"" + m + "\" not found.");
            this.mat = -556086273;
        }
    }

    /*
     * Exception decompiling
     */
    private void parseMaterial(String m) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[UNCONDITIONALDOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void parseVector(String v) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner scan = new Scanner(v);){
            scan.next();
            this.points.add(new MutVector().set(-Double.parseDouble(scan.next()), Double.parseDouble(scan.next()), Double.parseDouble(scan.next())));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void parseNormal(String vn) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner scan = new Scanner(vn);){
            scan.next();
            this.normals.add(new MutVector().set(-Double.parseDouble(scan.next()), Double.parseDouble(scan.next()), Double.parseDouble(scan.next())));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void parseTexture(String vt) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner scan = new Scanner(vt);){
            scan.next();
            this.textures.add(new MutVector().set(Double.parseDouble(scan.next()), 1.0 - Double.parseDouble(scan.next()), 0.0));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void parseFace(String f) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner scan = new Scanner(f);){
            scan.next();
            ArrayList<String[]> strList = new ArrayList<String[]>();
            while (scan.hasNext()) {
                strList.add(scan.next().split("/"));
            }
            ArrayList list = new ArrayList(strList.stream().map(s -> {
                Integer[] v = new Integer[]{Integer.parseInt(s[0]), ((String[])s).length >= 2 && !s[1].isBlank() ? Integer.parseInt(s[1]) : 0, ((String[])s).length >= 3 && !s[2].isBlank() ? Integer.parseInt(s[2]) : 0};
                return v;
            }).collect(Collectors.toList()));
            if (list.size() == 4) {
                Shape shape = this.makeFace4(((Integer[])list.get(3))[0], ((Integer[])list.get(0))[0], ((Integer[])list.get(1))[0], ((Integer[])list.get(2))[0], ((Integer[])list.get(3))[1], ((Integer[])list.get(0))[1], ((Integer[])list.get(1))[1], ((Integer[])list.get(2))[1], ((Integer[])list.get(3))[2], ((Integer[])list.get(0))[2], ((Integer[])list.get(1))[2], ((Integer[])list.get(2))[2]);
                this.group.addModels(shape);
            } else {
                Integer[] a = (Integer[])list.remove(0);
                Integer[] b = (Integer[])list.remove(0);
                boolean toggle = true;
                while (!list.isEmpty()) {
                    Integer[] c = (Integer[])list.remove(0);
                    Shape shape = toggle ? this.makeFace3(a[0], b[0], c[0], a[1], b[1], c[1], a[2], b[2], c[2]) : this.makeFace3(b[0], c[0], a[0], b[1], c[1], a[1], b[2], c[2], a[2]);
                    this.group.addModels(shape);
                    b = c;
                    boolean bl = toggle = !toggle;
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Shape makeFace4(int a, int b, int c, int d, int at, int bt, int ct, int dt, int an, int bn, int cn, int dn) {
        TextureInfo texture = this.texture;
        if (at > 0 && bt > 0 && ct > 0 && dt > 0) {
            Vector ta = this.textures.get(at);
            Vector tb = this.textures.get(bt);
            Vector tc = this.textures.get(ct);
            Vector td = this.textures.get(dt);
            texture = this.texture.subInfo(ta.getX(), ta.getY(), tc.getX() - ta.getX(), tc.getY() - ta.getY());
        }
        PlaneShape shape = an > 0 && bn > 0 && cn > 0 && dn > 0 ? new PlaneShape(this.points.get(a), this.points.get(b), this.points.get(c), this.points.get(d), this.normals.get(an), this.normals.get(bn), this.normals.get(cn), this.normals.get(dn), texture) : new PlaneShape(this.points.get(a), this.points.get(b), this.points.get(c), this.points.get(d), texture);
        shape.setTexture(texture.getTex());
        shape.setColor(this.mat);
        return shape;
    }

    private Shape makeFace3(int a, int b, int c, int at, int bt, int ct, int an, int bn, int cn) {
        PolygonShape shape = an > 0 && bn > 0 && cn > 0 ? new PolygonShape(this.points.get(a), this.points.get(b), this.points.get(c), this.normals.get(an), this.normals.get(bn), this.normals.get(cn), this.texture) : new PolygonShape(this.points.get(a), this.points.get(b), this.points.get(c), this.texture);
        shape.setTexture(this.texture.getTex());
        shape.setColor(this.mat);
        return shape;
    }
}

