/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.system.utils;

import java.util.ArrayList;
import java.util.List;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.model.utils.Bound;

public class ModelDivider {
    private static final int MAX_SHAPE = 128;
    private static final int DIVIDE = 3;
    private final List<ModelPlace> models = new ArrayList<ModelPlace>();

    public static void divide(ModelGroup m) {
        new ModelDivider().divideModel(m);
    }

    private void divideModel(ModelGroup m) {
        m.callConfirmCoordinate();
        m.setBound();
        m.getAllChildren().stream().forEach(c -> this.models.add(new ModelPlace(c.getBound().getCenter(), (Model)c)));
        m.clearChildren();
        this.addToModel(m, m.getBound().getMinX() - 1.0, m.getBound().getMaxX() + 1.0, m.getBound().getMinY() - 1.0, m.getBound().getMaxY() + 1.0, m.getBound().getMinZ() - 1.0, m.getBound().getMaxZ() + 1.0);
    }

    private void addToModel(ModelGroup pmh, double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        Bound bound = new Bound();
        bound.set(new MutVector().set(minX, minY, minZ));
        bound.set(new MutVector().set(maxX, maxY, maxZ));
        int cnt = (int)this.models.stream().filter(m -> bound.contain(m.place)).count();
        if (cnt == 0) {
            return;
        }
        if (cnt <= 128) {
            this.models.stream().filter(m -> bound.contain(m.place)).forEach(m -> pmh.addModels(m.model));
        } else {
            Bound b = new Bound();
            this.models.stream().filter(m -> bound.contain(m.place)).forEach(m -> b.set(m.place));
            b.set(new MutVector().set(b.getMaxX() + 0.1, b.getMaxY() + 0.1, b.getMaxZ() + 0.1));
            if (b.getMaxX() - b.getMinX() > b.getMaxY() - b.getMinY() && b.getMaxX() - b.getMinX() > b.getMaxZ() - b.getMinZ()) {
                minX = b.getMinX();
                maxX = b.getMaxX();
                int i = 0;
                while (i < 3) {
                    ModelGroup mh = new ModelGroup();
                    pmh.addModels(mh);
                    this.addToModel(mh, minX + (maxX - minX) / 3.0 * (double)i, minX + (maxX - minX) / 3.0 * (double)(i + 1), minY, maxY, minZ, maxZ);
                    ++i;
                }
            } else if (b.getMaxY() - b.getMinY() > b.getMaxZ() - b.getMinZ()) {
                minY = b.getMinY();
                maxY = b.getMaxY();
                int i = 0;
                while (i < 3) {
                    ModelGroup mh = new ModelGroup();
                    pmh.addModels(mh);
                    this.addToModel(mh, minX, maxX, minY + (maxY - minY) / 3.0 * (double)i, minY + (maxY - minY) / 3.0 * (double)(i + 1), minZ, maxZ);
                    ++i;
                }
            } else {
                minZ = b.getMinZ();
                maxZ = b.getMaxZ();
                int i = 0;
                while (i < 3) {
                    ModelGroup mh = new ModelGroup();
                    pmh.addModels(mh);
                    this.addToModel(mh, minX, maxX, minY, maxY, minZ + (maxZ - minZ) / 3.0 * (double)i, minZ + (maxZ - minZ) / 3.0 * (double)(i + 1));
                    ++i;
                }
            }
        }
    }

    private static class ModelPlace {
        final Vector place;
        final Model model;

        ModelPlace(Vector place, Model model) {
            this.place = place;
            this.model = model;
        }
    }
}

