/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.system.utils;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.comp_lot.glui.system.utils.FileUtils;
import net.comp_lot.glui.ui.ButtonLayout;
import net.comp_lot.glui.ui.Label;
import net.comp_lot.glui.ui.Slider;
import net.comp_lot.glui.ui.UIColor;
import net.comp_lot.ui.core.ClickListener;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;
import net.comp_lot.ui.layout.ScrollLayout;
import net.comp_lot.ui.layout.VerticalLinearLayout;

public class MenuManager {
    private static final int[] FONT_SIZE = new int[]{24, 40, 36, 32, 28};
    private static final int MIN_WIDTH = 400;
    private static final int MAX_WIDTH = 800;
    private static Function<DisplayInfo, ButtonLayout> buttonFactory = display -> new ButtonLayout((DisplayInfo)display);
    private final DisplayInfo display;
    private final Layout layout;
    private final Layout scroll;
    private final Map<String, Function<Map<String, String>, String>> stringGetters = new HashMap<String, Function<Map<String, String>, String>>();
    private final Map<String, Function<Map<String, String>, Component>> componentGetters = new HashMap<String, Function<Map<String, String>, Component>>();
    private final Map<String, Consumer<Map<String, String>>> listeners = new HashMap<String, Consumer<Map<String, String>>>();
    private final Map<String, Component> components = new HashMap<String, Component>();
    private final Deque<String> history = new ArrayDeque<String>();
    private String path = "./";

    public MenuManager(DisplayInfo display) {
        this.display = display;
        this.layout = new VerticalLinearLayout(display, 0);
        ((VerticalLinearLayout)this.layout).setAlign(VerticalLinearLayout.CENTER);
        this.layout.setMarginLeft(40);
        this.layout.setMarginRight(40);
        this.scroll = new ScrollLayout(display, this.layout, true, false);
        this.listeners.put("_back", args -> {
            this.history.removeLast();
            this.set(this.history.removeLast());
        });
    }

    public void set(String path) {
        if (((String)path).startsWith("./")) {
            path = this.path + ((String)path).substring(2);
        }
        this.history.addLast((String)path);
        this.path = ((String)path).substring(0, ((String)path).lastIndexOf("/") + 1);
        String text = FileUtils.loadFromStream(this.getClass().getResourceAsStream((String)path));
        this.setContents(text);
    }

    public void setContents(String text) {
        this.layout.clear();
        String[] stringArray = text.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.length() != 0) {
                int size = 0;
                while (s.charAt(size) == '#') {
                    ++size;
                }
                if (size > 0 && s.charAt(size) == ' ') {
                    s = s.substring(size + 1);
                } else {
                    size = 0;
                }
                Component lineComponent = this.parseLine(s, FONT_SIZE[size]);
                lineComponent.setMinWidth(400);
                lineComponent.setMaxWidth(800);
                this.layout.add(lineComponent);
            }
            ++n2;
        }
    }

    private Component parseLine(String s, int fontSize) {
        if (s.matches("^(\\$[a-zA-Z0-9_]+) *= *_\\+_(\\(.*\\))?")) {
            return this.parseSlider(s);
        }
        if (s.matches("^\\[.+\\]\\(.*\\)$")) {
            return this.parseButton(s, fontSize);
        }
        if (s.matches("^(\\$[a-zA-Z0-9_]+) *= *___(\\[[0-9]+\\])?(\\(.*\\))?")) {
            return this.parseForm(s, fontSize);
        }
        if (s.matches("^\\$[a-zA-Z0-9_]+") && this.componentGetters.containsKey(s)) {
            return this.componentGetters.get(s).apply(null);
        }
        Label label = this.parseLabel(s, fontSize);
        label.setMarginTop((int)((double)(fontSize - 20) * 1.5 * this.display.getScale()));
        return label;
    }

    private Label parseLabel(String s, int fontSize) {
        if (s.matches("\\$[a-zA-Z0-9_]+")) {
            s = this.getString(s);
        }
        Label label = new Label(this.display, fontSize, s);
        label.setBackground(0);
        label.setAlign(Label.Align.CENTER);
        return label;
    }

    private Component parseForm(String s, int fontSize) {
        String[] ss = s.replaceAll("^(\\$[a-zA-Z0-9_]+) *= *___(\\[[0-9]+\\])?(\\(.*\\))?", "$1\n$2\n$3").split("\n");
        String target = ss[0];
        s = ss[2].length() > 0 ? ss[2].substring(1, ss[2].length() - 1) : "";
        Label form = this.parseLabel(s, fontSize);
        form.setBackground(UIColor.DARK_GRAY.code());
        form.setClickListener(new ClickListener().setOnButton1Pressed((x, y) -> this.call(target)));
        form.setMarginTop((int)((double)(fontSize - 20) * 1.5 * this.display.getScale()));
        this.components.put(target, form);
        return form;
    }

    private Component parseButton(String s, int fontSize) {
        String target = s.substring(s.indexOf("(", s.indexOf("]")) + 1, s.indexOf(")", s.indexOf("]")));
        s = s.substring(s.indexOf("[") + 1, s.indexOf("]"));
        ButtonLayout button = MenuManager.getButton(this.display);
        button.add(this.parseLabel(s, fontSize));
        button.setClickListener(() -> {
            if (target.startsWith("./") || target.startsWith("/")) {
                this.set(target);
            } else {
                this.call(target);
            }
        });
        button.setMarginTop((int)((double)(fontSize - 20) * 1.5 * this.display.getScale()));
        return button;
    }

    private Component parseSlider(String s) {
        String[] ss = s.replaceAll("^(\\$[a-zA-Z0-9_]+) *= *_\\+_(\\(.*\\))?", "$1\n$2").split("\n");
        Slider slider = new Slider(this.display);
        slider.setClickListener(new ClickListener().setOnButton1Pressed((x, y) -> this.call(ss[0])));
        if (ss[1].length() > 0) {
            s = ss[1].substring(1, ss[1].length() - 1);
            if (s.matches("\\$[a-zA-Z0-9_]+")) {
                s = this.getString(s);
            }
            slider.setPos(Double.parseDouble(s));
        }
        this.components.put(ss[0], slider);
        return slider;
    }

    private void call(String target) {
        String name;
        HashMap<String, String> args = new HashMap<String, String>();
        if (target.indexOf(63) >= 0) {
            name = target.substring(0, target.indexOf(63));
            MenuManager.parseArgs(args, target.substring(target.indexOf(63) + 1));
        } else {
            name = target;
        }
        if (this.listeners.containsKey(name)) {
            this.listeners.get(name).accept(args);
        } else {
            System.err.println("listener \"" + name + "\" not found");
        }
    }

    private String getString(String target) {
        String name;
        HashMap<String, String> args = new HashMap<String, String>();
        if (target.indexOf(63) >= 0) {
            name = target.substring(0, target.indexOf(63));
            MenuManager.parseArgs(args, target.substring(target.indexOf(63) + 1));
        } else {
            name = target;
        }
        if (this.stringGetters.containsKey(name)) {
            return this.stringGetters.get(name).apply(args);
        }
        return "(" + name + ")";
    }

    private static void parseArgs(Map<String, String> args, String s) {
        while (s.indexOf(38) >= 0) {
            String v = s.substring(0, s.indexOf(38));
            s = s.substring(s.indexOf(38) + 1);
            args.put(v.substring(0, v.indexOf(61)), v.substring(v.indexOf(61) + 1));
        }
        args.put(s.substring(0, s.indexOf(61)), s.substring(s.indexOf(61) + 1));
    }

    public void setListener(String name, Consumer<Map<String, String>> listener) {
        if (listener == null) {
            this.listeners.remove(name);
        } else {
            this.listeners.put(name, listener);
        }
    }

    public void setGetter(String name, Function<Map<String, String>, String> getter) {
        if (getter == null) {
            this.stringGetters.remove(name);
        } else {
            this.stringGetters.put(name, getter);
        }
    }

    public void setComponentGetter(String name, Function<Map<String, String>, Component> getter) {
        if (getter == null) {
            this.componentGetters.remove(name);
        } else {
            this.componentGetters.put(name, getter);
        }
    }

    public Label getForm(String name) {
        return (Label)this.components.get(name);
    }

    public Slider getSlider(String name) {
        return (Slider)this.components.get(name);
    }

    public Component getComponent() {
        return this.scroll;
    }

    public static void setButtonFactory(Function<DisplayInfo, ButtonLayout> buttonFactory) {
        MenuManager.buttonFactory = buttonFactory;
    }

    public static ButtonLayout getButton(DisplayInfo display) {
        return buttonFactory.apply(display);
    }
}

