/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.system.utils;

import java.util.Arrays;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Face;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.model.Shape;
import net.comp_lot.glui.model.utils.RayCast;

public class InFaceEdgeDetector {
    private final Model model;

    public InFaceEdgeDetector(Model model) {
        this.model = model;
    }

    public void detectAndSet(float dist, float min, float max) {
        this.detectAndSet(this.model, dist, min, max);
    }

    private void detectAndSet(Model model, float dist, float min, float max) {
        if (model instanceof ModelGroup) {
            ((ModelGroup)model).getAllChildren().parallelStream().forEach(m -> this.detectAndSet((Model)m, dist, min, max));
        } else {
            Arrays.stream(((Shape)model).getFacesArray()).forEach(f4 -> this.detectAndSet((Face)f4, dist, min, max));
        }
    }

    private void detectAndSet(Face f, float dist, float min, float max) {
        int i = 0;
        while (i < 3) {
            Vector p1 = f.get(i);
            Vector p2 = f.get((i + 1) % 3);
            MutVector c = MutVector.iDivision(p1, p2, 1.0, 1.0);
            MutVector n = new MutVector().set(f.get((i + 2) % 3), c).toOrthogonal(new MutVector().set(p1, p2)).resize(1.0);
            MutVector d = new MutVector().set(f.getNormal()).reverse();
            RayCast cast = new RayCast(new MutVector().set(c).add(n, dist).add(d, -min), d, min + max);
            f.setInPlane(i, cast.cast(this.model) != null);
            ++i;
        }
    }
}

