/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.system.utils;

import java.util.Collection;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.display.DualDrawData;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.model.utils.Bound;
import net.comp_lot.glui.model.utils.TouchInfo;
import net.comp_lot.glui.system.utils.ModelDivider;

public class GridModelGroup
extends ModelGroup {
    private static final long serialVersionUID = -5092088045655715792L;
    private transient double drawDistance;
    private final transient double gridSize;
    private final transient double mapMinX;
    private final transient double mapMinZ;
    private final transient ModelGroup others;
    private final transient ModelGroup[][] grid;
    private final transient MutVector center = new MutVector();
    private final transient MutVector direction = new MutVector();

    private GridModelGroup(ModelGroup[][] grid, ModelGroup others, double gridSize, double mapMinX, double mapMinZ) {
        this(true, grid, others, gridSize, mapMinX, mapMinZ);
    }

    private GridModelGroup(boolean isVisible, ModelGroup[][] grid, ModelGroup others, double gridSize, double mapMinX, double mapMinZ) {
        super(isVisible);
        this.grid = grid;
        this.others = others;
        this.gridSize = gridSize;
        this.mapMinX = mapMinX;
        this.mapMinZ = mapMinZ;
    }

    public void setDrawDistance(double drawDistance) {
        this.drawDistance = drawDistance;
    }

    public void setCamera(Vector center, Vector direction) {
        this.center.set(center);
        this.direction.set(direction).toOrthogonal(Vector.Y_AXIS).resize(1.0);
    }

    @Override
    protected void onTouchTest(Model m, Collection<TouchInfo> list) {
        if (this.gridSize == 0.0) {
            super.onTouchTest(m, list);
        } else {
            this.others.touchTest(m, list);
            int sx = (int)((m.getBound().getMinX() - this.mapMinX) / this.gridSize) - 1;
            int ex = (int)((m.getBound().getMaxX() - this.mapMinX) / this.gridSize) + 2;
            int sz = (int)((m.getBound().getMinZ() - this.mapMinZ) / this.gridSize) - 1;
            int ez = (int)((m.getBound().getMaxZ() - this.mapMinZ) / this.gridSize) + 2;
            int i = sx;
            while (i <= ex) {
                int j = sz;
                while (j <= ez) {
                    if (this.isInside(i, j) && this.grid[i][j] != null) {
                        this.grid[i][j].touchTest(m, list);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    @Override
    public void putDrawData(DualDrawData data) {
        if (this.gridSize == 0.0) {
            super.putDrawData(data);
        } else {
            this.others.putDrawData(data);
            double cx = (this.center.getX() - this.mapMinX) / this.gridSize;
            int sx = (int)(cx - this.drawDistance / this.gridSize);
            int ex = (int)(cx + this.drawDistance / this.gridSize) + 1;
            double cz = (this.center.getZ() - this.mapMinZ) / this.gridSize;
            int sz = (int)(cz - this.drawDistance / this.gridSize);
            int ez = (int)(cz + this.drawDistance / this.gridSize) + 1;
            MutVector buf = new MutVector();
            int i = sx;
            while (i <= ex) {
                int j = sz;
                while (j <= ez) {
                    if (this.isInside(i, j) && this.grid[i][j] != null) {
                        buf.set((double)i + 0.5 - cx, 0.0, (double)j + 0.5 - cz).add(this.direction, this.gridSize).resize(1.0);
                        if (Vector.Dot(buf, this.direction) > 0.5) {
                            this.grid[i][j].putDrawData(data);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private boolean isInside(int x, int z) {
        return x >= 0 && x < this.grid.length && z >= 0 && z < this.grid[0].length;
    }

    public static GridModelGroup make(ModelGroup model, double gridSize) {
        int j;
        model.callConfirmCoordinate();
        model.setBound();
        double mapMinX = model.getBound().getMinX();
        double mapMinZ = model.getBound().getMinZ();
        double mapWidth = model.getBound().getWidth();
        double mapDepth = model.getBound().getDepth();
        ModelGroup[][] grid = new ModelGroup[(int)(mapWidth / gridSize) + 1][(int)(mapDepth / gridSize) + 1];
        int i = 0;
        while (i < grid.length) {
            int j2 = 0;
            while (j2 < grid[0].length) {
                grid[i][j2] = new ModelGroup();
                ++j2;
            }
            ++i;
        }
        ModelGroup others = new ModelGroup();
        GridModelGroup group = new GridModelGroup(grid, others, gridSize, mapMinX, mapMinZ);
        model.getAllChildren().stream().forEach(m -> {
            Bound b = m.getBound();
            if (b.getWidth() > gridSize * 2.0 || b.getDepth() > gridSize * 2.0) {
                others.addModels((Model)m);
            } else {
                Vector c = b.getCenter();
                grid[(int)((c.getX() - mapMinX) / gridSize)][(int)((c.getZ() - mapMinZ) / gridSize)].addModels((Model)m);
            }
        });
        int i2 = 0;
        while (i2 < grid.length) {
            j = 0;
            while (j < grid[0].length) {
                if (!grid[i2][j].getAllChildren().isEmpty()) {
                    ModelDivider.divide(grid[i2][j]);
                    group.addModels(grid[i2][j]);
                } else {
                    grid[i2][j] = null;
                }
                ++j;
            }
            ++i2;
        }
        ModelDivider.divide(group);
        if (!others.getAllChildren().isEmpty()) {
            ModelDivider.divide(others);
            group.addModels(others);
        }
        group.fix();
        others.fix();
        i2 = 0;
        while (i2 < grid.length) {
            j = 0;
            while (j < grid[0].length) {
                if (grid[i2][j] != null) {
                    grid[i2][j].fix();
                }
                ++j;
            }
            ++i2;
        }
        return group;
    }
}

