/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.system.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;

public class FileUtils {
    public static final String APP_DIR;

    static {
        String tmp;
        ProtectionDomain pd = new FileUtils().getClass().getProtectionDomain();
        CodeSource cs = pd.getCodeSource();
        URL location = cs.getLocation();
        try {
            URI uri = location.toURI();
            Path path = Paths.get(uri);
            tmp = path.getParent().toString() + File.separatorChar;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            tmp = "." + File.separatorChar;
        }
        APP_DIR = tmp;
    }

    public static String loadFromStream(InputStream is) {
        StringBuilder sb = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));){
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append('\n');
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static String loadFile(String name) throws FileNotFoundException {
        File file = new File(APP_DIR + name);
        try {
            if (!file.getCanonicalPath().startsWith(APP_DIR)) {
                throw new FileNotFoundException("\"" + name + "\" is not a child of the game dir.");
            }
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.getLocalizedMessage());
        }
        return FileUtils.loadFromStream(new FileInputStream(file));
    }

    public static void writeFile(String name, String value) {
        File file = new File(APP_DIR + name);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));){
                bw.write(value);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

