/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.system.utils;

import java.util.function.Supplier;

public class FPSKeeper {
    private final long targetInterval;
    private long time;
    private final long[] frameTimes = new long[32];
    private int frameIndex = 0;
    private double fps = 0.0;

    public FPSKeeper() {
        this(60);
    }

    public FPSKeeper(int fps) {
        this.targetInterval = fps > 0 ? 1000000000L / (long)fps : 0L;
    }

    public void loop(Supplier<Boolean> onFrame) {
        while (onFrame.get().booleanValue()) {
            this.keep();
        }
    }

    public void keep() {
        long now = System.nanoTime();
        if (this.time > now) {
            try {
                Thread.sleep((this.time - now) / 1000000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.time = this.time + this.targetInterval > now ? (this.time += this.targetInterval) : now + this.targetInterval;
        int next = (this.frameIndex + 1) % this.frameTimes.length;
        this.frameTimes[this.frameIndex] = now;
        this.fps = 1.0E9 / (double)(this.frameTimes[this.frameIndex] - this.frameTimes[next]) * (double)(this.frameTimes.length - 1);
        this.frameIndex = next;
    }

    public double getFps() {
        return this.fps;
    }
}

