/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.system;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.comp_lot.glui.amount.FastSerializable;
import net.comp_lot.glui.amount.UpdateFlagData;

public class OperationEvent {

    public static enum Action {
        PRESS,
        RELEASE;

    }

    public static enum KeyCode {
        KEY_0(48),
        KEY_1(49),
        KEY_2(50),
        KEY_3(51),
        KEY_4(52),
        KEY_5(53),
        KEY_6(54),
        KEY_7(55),
        KEY_8(56),
        KEY_9(57),
        KEY_A(65),
        KEY_B(66),
        KEY_C(67),
        KEY_D(68),
        KEY_E(69),
        KEY_F(70),
        KEY_G(71),
        KEY_H(72),
        KEY_I(73),
        KEY_J(74),
        KEY_K(75),
        KEY_L(76),
        KEY_M(77),
        KEY_N(78),
        KEY_O(79),
        KEY_P(80),
        KEY_Q(81),
        KEY_R(82),
        KEY_S(83),
        KEY_T(84),
        KEY_U(85),
        KEY_V(86),
        KEY_W(87),
        KEY_X(88),
        KEY_Y(89),
        KEY_Z(90),
        KEY_MINUS(45),
        KEY_PERIOD(46),
        KEY_COMMA(44),
        KEY_SPACE(32),
        KEY_SLASH(47),
        KEY_LEFT_SHIFT(340),
        KEY_RIGHT_SHIFT(344),
        KEY_LEFT_CONTROL(341),
        KEY_RIGHT_CONTROL(345),
        KEY_ENTER(257),
        KEY_TAB(258),
        KEY_BACKSPACE(259),
        KEY_DELETE(261),
        KEY_ESCAPE(256),
        KEY_INSERT(260),
        KEY_UP(265),
        KEY_DOWN(264),
        KEY_LEFT(263),
        KEY_RIGHT(262),
        KEY_HOME(268),
        KEY_END(269),
        KEY_PAGE_UP(266),
        KEY_PAGE_DOWN(267),
        KEY_F1(290),
        KEY_F2(291),
        KEY_F3(292),
        KEY_F4(293),
        KEY_F5(294),
        KEY_F6(295),
        KEY_F7(296),
        KEY_F8(297),
        KEY_F9(298),
        KEY_F10(299),
        KEY_F11(300),
        KEY_F12(301),
        MOUSE_LEFT(0),
        MOUSE_RIGHT(1),
        MOUSE_MIDDLE(2),
        MOUSE_4(3),
        MOUSE_5(4);

        private final int code;

        private KeyCode(int value) {
            this.code = value;
        }

        public boolean checkCode(int value) {
            return this.code == value;
        }

        public static KeyCode toKeyCode(int ordinal) {
            if (ordinal < 0 || ordinal >= KeyCode.values().length) {
                return null;
            }
            return KeyCode.values()[ordinal];
        }

        public int getCode() {
            return this.code;
        }

        public String getShortName() {
            if (this.name().startsWith("KEY_")) {
                return this.name().substring(4);
            }
            return this.name();
        }
    }

    public static class KeyState
    extends UpdateFlagData
    implements FastSerializable {
        private final long[] state = new long[(KeyCode.values().length - 1) / 64 + 1];

        public void reset() {
            int i = 0;
            while (i < this.state.length) {
                this.state[i] = 0L;
                ++i;
            }
            this.setUpdated();
        }

        public void set(KeyState ks) {
            int i = 0;
            while (i < this.state.length) {
                this.state[i] = ks.state[i];
                ++i;
            }
            this.setUpdated();
        }

        public void setKey(int code, boolean pressed) {
            KeyCode[] keyCodeArray = KeyCode.values();
            int n = keyCodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                KeyCode key = keyCodeArray[n2];
                if (key.checkCode(code)) {
                    this.setKey(key, pressed);
                }
                ++n2;
            }
        }

        public void setKey(KeyCode key, boolean pressed) {
            this.state[key.ordinal() / 64] = pressed ? this.state[key.ordinal() / 64] | 1L << key.ordinal() % 64 : this.state[key.ordinal() / 64] & (1L << key.ordinal() % 64 ^ 0xFFFFFFFFFFFFFFFFL);
            this.setUpdated();
        }

        public boolean isPressed(KeyCode key) {
            return (this.state[key.ordinal() / 64] & 1L << key.ordinal() % 64) != 0L;
        }

        @Override
        public void read(ObjectInputStream s) throws IOException {
            int i = 0;
            while (i < this.state.length) {
                long nState = s.readLong();
                if (this.state[i] != nState) {
                    this.state[i] = nState;
                    this.setUpdated();
                }
                ++i;
            }
        }

        @Override
        public void write(ObjectOutputStream s) throws IOException {
            int i = 0;
            while (i < this.state.length) {
                s.writeLong(this.state[i]);
                ++i;
            }
            this.resetUpdated();
        }
    }
}

