/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.system;

import java.io.FileNotFoundException;
import java.util.Scanner;
import net.comp_lot.glui.system.utils.FileUtils;

public class GluiConfig {
    private float fovy = 1.16f;
    private String fontName = null;
    private double uiScale = 1.0;
    private float volumeIn = 1.0f;
    private float volumeOut = 1.0f;
    private float alUnit = 3.0f;
    private float volumeUi = 0.5f;

    public float getFovy() {
        return this.fovy;
    }

    public void setFovy(float fovy) {
        this.fovy = fovy;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public double getUiScale() {
        return this.uiScale;
    }

    public void setUiScale(double uiScale) {
        this.uiScale = uiScale;
    }

    public float getVolumeIn() {
        return this.volumeIn;
    }

    public void setVolumeIn(float volumeIn) {
        this.volumeIn = volumeIn;
    }

    public float getVolumeOut() {
        return this.volumeOut;
    }

    public void setVolumeOut(float volumeOut) {
        this.volumeOut = volumeOut;
    }

    public float getAlUnit() {
        return this.alUnit;
    }

    public void setAlUnit(float alUnit) {
        this.alUnit = alUnit;
    }

    public float getVolumeUi() {
        return this.volumeUi;
    }

    public void setVolumeUi(float volumeUi) {
        this.volumeUi = volumeUi;
    }

    protected void saveParams(StringBuilder sb) {
        sb.append("[glui_config]\n");
        sb.append(String.format("ui_scale=%.2f\n", this.uiScale));
        sb.append(String.format("volume_in=%.2f\n", Float.valueOf(this.volumeIn)));
        sb.append(String.format("volume_out=%.2f\n", Float.valueOf(this.volumeOut)));
        sb.append(String.format("al_unit=%.2f\n", Float.valueOf(this.alUnit)));
        sb.append(String.format("volume_ui=%.2f\n", Float.valueOf(this.getVolumeUi())));
    }

    protected void loadParam(String param, String value) {
        switch (param) {
            case "ui_scale": {
                this.uiScale = Double.parseDouble(value);
                break;
            }
            case "volume_in": {
                this.volumeIn = Float.parseFloat(value);
                break;
            }
            case "volume_out": {
                this.volumeOut = Float.parseFloat(value);
                break;
            }
            case "al_unit": {
                this.alUnit = Float.parseFloat(value);
                break;
            }
            case "volume_ui": {
                this.setVolumeUi(Float.parseFloat(value));
                break;
            }
            default: {
                System.err.println("Unknown config : \"" + param + "\"");
            }
        }
    }

    public void save() {
        StringBuilder sb = new StringBuilder();
        this.saveParams(sb);
        FileUtils.writeFile("config.ini", sb.toString());
    }

    public void load() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Scanner scan = new Scanner(FileUtils.loadFile("config.ini"));){
                while (scan.hasNextLine()) {
                    String line = scan.nextLine().trim();
                    if (line.isEmpty() || line.startsWith("#") || line.startsWith(";") || line.matches("\\[.+\\]")) continue;
                    if (line.matches("([a-zA-Z0-9_]+) *= *\"?(.*)\"?")) {
                        String param = line.replaceAll("([a-zA-Z0-9_]+) *= *\"?(.*)\"?", "$1");
                        String value = line.replaceAll("([a-zA-Z0-9_]+) *= *\"?(.*)\"?", "$2");
                        this.loadParam(param, value);
                        continue;
                    }
                    System.err.println("Invalid config : \"" + line + "\"");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }
}

