/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.system;

import java.awt.SplashScreen;
import java.awt.image.BufferedImage;
import java.util.function.Function;
import net.comp_lot.glui.display_lwjgl.GLMain;
import net.comp_lot.glui.sound_lwjgl.ALAudioSystem;
import net.comp_lot.glui.system.Game;
import net.comp_lot.glui.system.GameMode;
import net.comp_lot.glui.system.GluiConfig;
import net.comp_lot.glui.ui.Background;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.layout.ScrollLayout;

public class GluiApplication {
    private final GluiConfig config;
    private String title = "glui window";
    private BufferedImage icon;
    private BufferedImage texture;
    private Function<Game, GameMode> firstMode = game -> new GameMode((Game)game, 60){

        @Override
        protected void onFrame() {
        }
    };
    private Runnable onClose = () -> {};

    public GluiApplication(GluiConfig config) {
        this.config = config;
        config.load();
        ScrollLayout.setDefaultScrollBar(display -> new Background((DisplayInfo)display, 34));
    }

    public void launch() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ALAudioSystem audioSystem = new ALAudioSystem(this.config, false);){
            GLMain main = new GLMain(this.config, this.title, this.icon, this.texture, audioSystem);
            GluiApplication.closeSplash();
            main.run(this.firstMode);
            this.onClose.run();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        System.exit(0);
    }

    private static void closeSplash() {
        try {
            SplashScreen splash = SplashScreen.getSplashScreen();
            if (splash != null) {
                splash.close();
            }
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
    }

    public GluiApplication setTitle(String title) {
        this.title = title;
        return this;
    }

    public GluiApplication setIcon(BufferedImage icon) {
        this.icon = icon;
        return this;
    }

    public GluiApplication setTexture(BufferedImage texture) {
        this.texture = texture;
        return this;
    }

    public GluiApplication setALUnit(float unit) {
        this.config.setAlUnit(unit);
        return this;
    }

    public GluiApplication setFirstMode(Function<Game, GameMode> firstMode) {
        this.firstMode = firstMode;
        return this;
    }

    public GluiApplication setOnClose(Runnable onClose) {
        this.onClose = onClose;
        return this;
    }
}

