/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.system;

import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Function;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.display.DualDrawData;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.system.DialogBuilder;
import net.comp_lot.glui.system.Game;
import net.comp_lot.glui.system.GameAdapter;
import net.comp_lot.glui.system.OperationEvent;
import net.comp_lot.glui.system.utils.FPSKeeper;
import net.comp_lot.glui.ui.InteractiveComponent;
import net.comp_lot.glui.ui.UIDisplay;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.CursorType;

public abstract class GameMode
extends GameAdapter {
    private static final int REPEAT_TIME_MILLIS = 100;
    private static final int REPEAT_START_TIME_MILLIS = 500;
    private static final int REPEAT_START_COUNT = 5;
    protected final ModelGroup mainModel = new ModelGroup();
    protected final UIDisplay uiDisplay;
    private boolean isInMenu;
    private boolean isInMenuOld;
    private long hintStartTime;
    private int hintX;
    private int hintY;
    private Component hintComponent;
    private Component hint;
    private Component hoverComponent;
    private InteractiveComponent activeComponent = null;
    private final FPSKeeper fpsKeeper;
    private long beforeTime;
    private long sumTime;
    private boolean repeatFrame = false;
    private final Queue<DialogBuilder> dialogQueue = new LinkedList<DialogBuilder>();

    protected GameMode(Game game, int targetFps) {
        super(game);
        this.fpsKeeper = new FPSKeeper(targetFps);
        this.uiDisplay = new UIDisplay(game);
        this.beforeTime = System.currentTimeMillis();
    }

    protected abstract void onFrame();

    public double getFps() {
        return this.fpsKeeper.getFps();
    }

    public UIDisplay getUIDisplay() {
        return this.uiDisplay;
    }

    protected void onClose() {
    }

    protected void onMouseAction(int button, OperationEvent.Action action, int mouseX, int mouseY) {
    }

    protected void onMouseMove(float x, float y) {
    }

    protected void onMouseScroll(double size) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSizeChanged(int width, int height) {
        UIDisplay uIDisplay = this.uiDisplay;
        synchronized (uIDisplay) {
            if (width <= 0 || height <= 0) {
                this.uiDisplay.setSize(1, 1);
            } else {
                this.uiDisplay.setSize(width, height);
            }
            this.uiDisplay.getModel().moveToP(new MutVector().set(-this.uiDisplay.getWidth() / 2, this.uiDisplay.getHeight() / 2, 0.0));
        }
    }

    protected void addUI(Component c) {
        this.uiDisplay.getBaseLayout().add(c);
    }

    protected void addUI(int i, Component c) {
        this.uiDisplay.getBaseLayout().add(i, c);
    }

    protected void removeUI(Component c) {
        this.uiDisplay.getBaseLayout().remove(c);
    }

    public void showDialog(DialogBuilder dialog) {
        this.dialogQueue.add(dialog);
        if (this.dialogQueue.size() == 1) {
            dialog.show(this);
        }
    }

    void pollDialog() {
        this.dialogQueue.poll();
        if (this.dialogQueue.size() > 0) {
            this.dialogQueue.peek().show(this);
        }
    }

    protected void setMode(Function<Game, GameMode> modeFactory) {
        this.getGame().setMode(modeFactory);
    }

    public final boolean getKeyDownIgnoreMenu(OperationEvent.KeyCode key) {
        return super.getKeyDown(key);
    }

    public final boolean getKeyStateIgnoreMenu(OperationEvent.KeyCode key) {
        return super.getKeyState(key);
    }

    @Override
    public final boolean getKeyDown(OperationEvent.KeyCode key) {
        return !this.isInMenu() && super.getKeyDown(key);
    }

    @Override
    public final boolean getKeyState(OperationEvent.KeyCode key) {
        return !this.isInMenu() && super.getKeyState(key);
    }

    public final boolean getKeyDownRepeat(OperationEvent.KeyCode key) {
        return !this.isInMenu() && this.getKeyDownRepeatIgnoreMenu(key);
    }

    public final boolean getKeyDownRepeatIgnoreMenu(OperationEvent.KeyCode key) {
        return this.getKeyDownIgnoreMenu(key) || this.repeatFrame && this.getKeyRepeat(key) > 5;
    }

    public final void setActiveComponent(InteractiveComponent active) {
        if (this.activeComponent != null) {
            this.activeComponent.deactivate();
        }
        this.activeComponent = active;
        if (this.activeComponent != null) {
            this.activeComponent.activate();
        }
    }

    protected final boolean isInMenu() {
        return this.isInMenu || this.isInMenuOld;
    }

    protected void setInMenu(boolean menu) {
        this.isInMenu = menu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void callOnFrame() {
        if (this.activeComponent != null) {
            this.activeComponent.frame(this);
        }
        UIDisplay uIDisplay = this.uiDisplay;
        synchronized (uIDisplay) {
            this.uiDisplay.draw();
            this.updateMousePosition(this.getMouseX(), this.getMouseY());
        }
        this.repeatFrame = false;
        long t = System.currentTimeMillis();
        this.sumTime += t - this.beforeTime;
        this.beforeTime = t;
        while (this.sumTime > 100L) {
            this.sumTime -= 100L;
            this.getGame().getKeyState().updateRepeat();
            this.repeatFrame = true;
        }
        this.onFrame();
        this.isInMenuOld = this.isInMenu;
        this.getGame().getAudioSystem().update();
        this.fpsKeeper.keep();
    }

    private void updateMousePosition(int mouseX, int mouseY) {
        this.updateHint(mouseX, mouseY);
        Component component = this.uiDisplay.getRootLayout().getClickedComponent(mouseX, mouseY);
        if (component != this.hoverComponent) {
            if (this.hoverComponent != null) {
                this.hoverComponent.onHoverExit();
            }
            this.hoverComponent = component;
            if (this.hoverComponent != null) {
                this.hoverComponent.onHoverEnter();
            }
        }
        this.getGame().setCursor(component == null ? CursorType.NORMAL : component.getCursorType());
    }

    private void updateHint(int mouseX, int mouseY) {
        long time = System.currentTimeMillis();
        Component hintComponent = this.uiDisplay.getRootLayout().getComponentByPosition(mouseX, mouseY, Component.FILTER_HINT);
        if (!(this.hint != null && hintComponent == this.hintComponent || mouseX == this.hintX && mouseY == this.hintY)) {
            this.hintX = mouseX;
            this.hintY = mouseY;
            this.hintStartTime = time;
        }
        this.hintComponent = hintComponent;
        if (this.hint != null) {
            this.uiDisplay.getOverlayLayout().remove(this.hint);
        }
        if (hintComponent != null) {
            this.hint = hintComponent.getHint(time - this.hintStartTime);
            if (this.hint != null) {
                this.uiDisplay.getOverlayLayout().add(this.hint);
                this.uiDisplay.getOverlayLayout().setPlace(this.hint, this.hintX, this.hintY + 28);
            }
        } else {
            this.hint = null;
        }
    }

    final void putDrawData(DualDrawData mainData, DualDrawData uiData) {
        this.mainModel.putDrawData(mainData);
        this.uiDisplay.getModel().putDrawData(uiData);
    }

    final void callOnMouseScroll(double size) {
        if (this.getKeyState(OperationEvent.KeyCode.KEY_LEFT_SHIFT) || this.getKeyState(OperationEvent.KeyCode.KEY_RIGHT_SHIFT)) {
            this.uiDisplay.getRootLayout().scroll((int)(size * 64.0), 0, this.getMouseX(), this.getMouseY());
        } else {
            this.uiDisplay.getRootLayout().scroll(0, (int)(size * 64.0), this.getMouseX(), this.getMouseY());
        }
        this.onMouseScroll(size);
    }

    final void onUIClick(int button, OperationEvent.Action action, int mouseX, int mouseY) {
        if (action == OperationEvent.Action.PRESS) {
            switch (button) {
                case 0: {
                    this.uiDisplay.getRootLayout().onButton1Pressed(mouseX, mouseY);
                    break;
                }
                case 1: {
                    this.uiDisplay.getRootLayout().onButton2Pressed(mouseX, mouseY);
                    break;
                }
                case 2: {
                    this.uiDisplay.getRootLayout().onButton3Pressed(mouseX, mouseY);
                    break;
                }
                case 3: {
                    this.uiDisplay.getRootLayout().onButton4Pressed(mouseX, mouseY);
                    break;
                }
                case 4: {
                    this.uiDisplay.getRootLayout().onButton5Pressed(mouseX, mouseY);
                    break;
                }
            }
        } else if (action == OperationEvent.Action.RELEASE) {
            switch (button) {
                case 0: {
                    this.uiDisplay.getRootLayout().onButton1Released(mouseX, mouseY);
                    break;
                }
                case 1: {
                    this.uiDisplay.getRootLayout().onButton2Released(mouseX, mouseY);
                    break;
                }
                case 2: {
                    this.uiDisplay.getRootLayout().onButton3Released(mouseX, mouseY);
                    break;
                }
                case 3: {
                    this.uiDisplay.getRootLayout().onButton4Released(mouseX, mouseY);
                    break;
                }
                case 4: {
                    this.uiDisplay.getRootLayout().onButton5Released(mouseX, mouseY);
                    break;
                }
            }
        }
    }
}

