/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.system;

import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Function;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.display_lwjgl.GLGameDisplay;
import net.comp_lot.glui.sound.AudioSystem;
import net.comp_lot.glui.system.GameMode;
import net.comp_lot.glui.system.GluiConfig;
import net.comp_lot.glui.system.OperationEvent;
import net.comp_lot.glui.system.RenderOptions;
import net.comp_lot.glui.system.utils.KeyStateManager;
import net.comp_lot.ui.core.CursorType;

public final class Game {
    private final GluiConfig config;
    private final Queue<Runnable> eventQueue = new LinkedList<Runnable>();
    private final Queue<Integer> charQueue = new LinkedList<Integer>();
    private Function<Game, GameMode> nextMode = null;
    private final GLGameDisplay display;
    private final RenderOptions renderOptions;
    private int width;
    private int height;
    private final OperationEvent.KeyState keyState = new OperationEvent.KeyState();
    private final KeyStateManager keyStateManager = new KeyStateManager();
    private boolean mouseInit = false;
    private float mouseX = -1.0f;
    private float mouseY = -1.0f;
    private boolean showPointer = true;
    private final AudioSystem audioSystem;
    private GameMode mode = new GameMode(this, 60){

        @Override
        protected void onFrame() {
        }
    };

    public Game(GluiConfig config, GLGameDisplay display, AudioSystem audioSystem) {
        this.config = config;
        this.display = display;
        this.audioSystem = audioSystem;
        this.renderOptions = new RenderOptions(display);
    }

    public GluiConfig getConfig() {
        return this.config;
    }

    public AudioSystem getAudioSystem() {
        return this.audioSystem;
    }

    public synchronized void setMode(Function<Game, GameMode> modeFactory) {
        this.nextMode = modeFactory;
    }

    private void setMode() {
        if (this.mode != null) {
            this.mode.onClose();
            this.mode = null;
        }
        this.keyState.reset();
        this.mode = this.nextMode.apply(this);
        this.mode.onSizeChanged(this.width, this.height);
        this.nextMode = null;
    }

    public synchronized void frame() {
        if (this.nextMode != null) {
            this.setMode();
        }
        this.keyStateManager.set(this.keyState);
        this.mode.callOnFrame();
        while (!this.eventQueue.isEmpty()) {
            this.eventQueue.poll().run();
        }
        if (!this.charQueue.isEmpty()) {
            this.charQueue.clear();
        }
        this.display.resetDrawData();
        this.mode.putDrawData(this.display.getMainDrawData(), this.display.getUIDrawData());
    }

    public byte[] getImage() {
        return this.display.getImage();
    }

    void setCamera(Vector camera, Vector axis, Vector up) {
        this.display.setMainCamera(camera, axis, up);
    }

    KeyStateManager getKeyState() {
        return this.keyStateManager;
    }

    Integer pollChar() {
        if (this.charQueue.isEmpty()) {
            return null;
        }
        return this.charQueue.poll();
    }

    void showPointer(boolean enable) {
        this.showPointer = enable;
        this.display.showPointer(enable);
    }

    void setCursor(CursorType cursor) {
        this.display.setCursor(cursor.ordinal());
    }

    public RenderOptions getRenderOptions() {
        return this.renderOptions;
    }

    public synchronized void sizeChanged(int width, int height) {
        this.width = width;
        this.height = height;
        this.mode.onSizeChanged(width, height);
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    public synchronized void keyEvent(boolean pressed, int key) {
        this.keyState.setKey(key, pressed);
    }

    public synchronized void charEvent(int unicode) {
        this.charQueue.add(unicode);
    }

    public synchronized void mouseMove(float x, float y) {
        if (this.mouseInit) {
            this.mode.onMouseMove(x - this.mouseX, y - this.mouseY);
        } else {
            this.mouseInit = true;
        }
        this.mouseX = x;
        this.mouseY = y;
    }

    int getMouseX() {
        return (int)this.mouseX;
    }

    int getMouseY() {
        return (int)this.mouseY;
    }

    public synchronized void mouseScroll(double size) {
        this.mode.callOnMouseScroll(size);
    }

    public synchronized void mouseAction(int button, OperationEvent.Action action, int mouseX, int mouseY) {
        this.keyState.setKey(button, action == OperationEvent.Action.PRESS);
        this.eventQueue.add(() -> {
            if (this.showPointer) {
                this.mode.onUIClick(button, action, mouseX, mouseY);
            }
            this.mode.onMouseAction(button, action, mouseX, mouseY);
        });
    }
}

