/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.system;

import java.util.function.Function;
import net.comp_lot.glui.system.GameMode;
import net.comp_lot.glui.system.utils.MenuManager;
import net.comp_lot.ui.core.Component;
import net.comp_lot.ui.core.DisplayInfo;
import net.comp_lot.ui.core.Layout;
import net.comp_lot.ui.layout.CenterLayout;
import net.comp_lot.ui.layout.FrameLayout;

public class DialogBuilder {
    private static Function<DisplayInfo, Component> bgFactory = display -> null;
    private Runnable close = () -> {};
    private final Layout container;

    private DialogBuilder(GameMode context, MenuManager content) {
        this(context, content.getComponent());
    }

    private DialogBuilder(GameMode context, Component content) {
        FrameLayout frame = new FrameLayout(context.uiDisplay, content);
        frame.setPadding(24);
        frame.setPaddingBottom(48);
        frame.setBackground(bgFactory.apply(context.uiDisplay));
        this.container = new CenterLayout(context.uiDisplay, frame);
    }

    public static DialogBuilder newMessageDialog(GameMode context, String message) {
        return DialogBuilder.newMessageDialog(context, message, "OK", () -> {});
    }

    public static DialogBuilder newMessageDialog(GameMode context, String message, String button, Runnable closeFunc) {
        MenuManager content = new MenuManager(context.uiDisplay);
        DialogBuilder dialogBuilder = new DialogBuilder(context, content);
        content.setGetter("$message", args -> message);
        content.setGetter("$close", args -> button);
        content.setListener("close", args -> {
            closeFunc.run();
            dialogBuilder.close();
        });
        content.setContents("# $message\n# [$close](close)");
        return dialogBuilder;
    }

    public static DialogBuilder newMessageOnlyDialog(GameMode context, String message) {
        MenuManager content = new MenuManager(context.uiDisplay);
        DialogBuilder dialogBuilder = new DialogBuilder(context, content);
        content.setGetter("$message", args -> message);
        content.setContents("# $message");
        return dialogBuilder;
    }

    public static DialogBuilder newYesNoDialog(GameMode context, String message, String yes, String no, Runnable yesFunc, Runnable noFunc) {
        MenuManager content = new MenuManager(context.uiDisplay);
        DialogBuilder dialogBuilder = new DialogBuilder(context, content);
        content.setGetter("$message", args -> message);
        content.setGetter("$yes", args -> yes);
        content.setListener("yes", args -> {
            yesFunc.run();
            dialogBuilder.close();
        });
        content.setGetter("$no", args -> no);
        content.setListener("no", args -> {
            noFunc.run();
            dialogBuilder.close();
        });
        content.setContents("# $message\n# [$yes](yes)\n# [$no](no)");
        return dialogBuilder;
    }

    public static DialogBuilder newFreeDialog(GameMode context, MenuManager content) {
        return new DialogBuilder(context, content);
    }

    public static DialogBuilder newFreeDialog(GameMode context, Component content) {
        return new DialogBuilder(context, content);
    }

    public void setContainerBackground(Component bg) {
        this.container.setBackground(bg);
    }

    public void show(GameMode context) {
        this.close = () -> {
            context.removeUI(this.container);
            context.pollDialog();
        };
        context.addUI(this.container);
    }

    public void close() {
        this.close.run();
    }

    public static void setBGFactory(Function<DisplayInfo, Component> bgFactory) {
        DialogBuilder.bgFactory = bgFactory;
    }
}

