/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.sound_lwjgl;

import java.util.ArrayDeque;
import java.util.Queue;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.sound_lwjgl.ALSoundSource;
import net.comp_lot.glui.sound_lwjgl.StreamingSoundFrame;
import net.comp_lot.glui.system.GluiConfig;
import org.lwjgl.openal.AL10;

class StreamingSoundSource
extends ALSoundSource {
    private static final int SAMPLING_RATE = 16384;
    private static final int BUFFER_SIZE = 512;
    private static final StreamingSoundFrame zeroFrame = new StreamingSoundFrame(new short[512], 0.0f, Vector.ZERO);
    private final Queue<StreamingSoundFrame> frames = new ArrayDeque<StreamingSoundFrame>();
    private int drop = 0;

    StreamingSoundSource(Vector pos, Vector speed, float gain, GluiConfig config) {
        super(pos, speed, gain, config);
        int[] buffer = new int[]{AL10.alGenBuffers(), AL10.alGenBuffers()};
        AL10.alBufferData(buffer[0], 4353, new short[512], 16384);
        AL10.alBufferData(buffer[1], 4353, new short[512], 16384);
        AL10.alSourceQueueBuffers(this.getSourcePointer(), buffer[0]);
        AL10.alSourceQueueBuffers(this.getSourcePointer(), buffer[1]);
        AL10.alSourcePlay(this.getSourcePointer());
    }

    @Override
    public boolean update() {
        int processed = AL10.alGetSourcei(this.getSourcePointer(), 4118);
        while (processed-- > 0) {
            int buffer = AL10.alSourceUnqueueBuffers(this.getSourcePointer());
            while (this.frames.size() > 3) {
                this.frames.poll();
            }
            StreamingSoundFrame frame = this.frames.poll();
            if (frame == null) {
                frame = zeroFrame;
                ++this.drop;
            } else {
                this.drop = 0;
            }
            AL10.alSource3f(this.getSourcePointer(), 4100, (float)frame.getPos().getX() * this.getConfig().getAlUnit(), (float)frame.getPos().getY() * this.getConfig().getAlUnit(), (float)(-frame.getPos().getZ()) * this.getConfig().getAlUnit());
            AL10.alBufferData(buffer, 4353, frame.getSamples(), 16384);
            AL10.alSourceQueueBuffers(this.getSourcePointer(), buffer);
        }
        if (this.isPlaying()) {
            if (AL10.alGetSourcei(this.getSourcePointer(), 4112) != 4114) {
                AL10.alSourcePlay(this.getSourcePointer());
            }
            return false;
        }
        this.free();
        return true;
    }

    @Override
    public boolean isPlaying() {
        return this.drop < 30 && !this.isStopped();
    }

    @Override
    public double getRemainSecond() {
        return this.isPlaying() ? 10000 : 0;
    }

    void add(StreamingSoundFrame frame) {
        this.frames.add(frame);
    }
}

