/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.sound_lwjgl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.comp_lot.glui.amount.FastSerializable;
import net.comp_lot.glui.amount.Vector;

public final class StreamingSoundFrame
implements FastSerializable {
    private static final float RANGE = 65535.0f;
    private static final float THRESHOLD = 0.06666667f;
    private short[] samples;
    private float volume;
    private boolean mute = true;
    private Vector pos;

    public StreamingSoundFrame() {
    }

    public StreamingSoundFrame(short[] samples, StreamingSoundFrame old) {
        this(samples, old.getVolume(), null);
    }

    public StreamingSoundFrame(short[] samples, float oldVolume, Vector pos) {
        this.samples = samples;
        this.pos = pos;
        this.calcVolume(oldVolume);
    }

    private void calcVolume(float oldVolume) {
        short min = 0;
        short max = 0;
        int i = 0;
        while (i < this.samples.length) {
            if (min > this.samples[i]) {
                min = this.samples[i];
            }
            if (max < this.samples[i]) {
                max = this.samples[i];
            }
            ++i;
        }
        this.volume = oldVolume * 0.75f + (float)(max - min) / 65535.0f * 0.25f;
        this.mute = this.volume < 0.06666667f;
    }

    short[] getSamples() {
        return this.samples;
    }

    public boolean isMute() {
        return this.mute;
    }

    public float getVolume() {
        return this.volume;
    }

    @Override
    public void read(ObjectInputStream s) throws IOException {
        int length = s.readInt();
        this.samples = new short[length];
        this.mute = s.readBoolean();
        if (!this.mute) {
            int i = 0;
            while (i < length) {
                this.samples[this.samples.length - i - 1] = s.readShort();
                ++i;
            }
        }
    }

    @Override
    public void write(ObjectOutputStream s) throws IOException {
        s.writeInt(this.samples.length);
        s.writeBoolean(this.mute);
        if (!this.mute) {
            int i = 0;
            while (i < this.samples.length) {
                s.writeShort(this.samples[this.samples.length - i - 1]);
                ++i;
            }
        }
    }

    public void setPos(Vector pos) {
        this.pos = pos;
    }

    public Vector getPos() {
        return this.pos;
    }
}

