/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.sound_lwjgl;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.stb.STBVorbis;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.libc.LibCStdlib;

public class SoundRawData
implements Closeable {
    private int channels;
    private int sampleRate;
    private ShortBuffer rawAudioBuffer;

    public SoundRawData(InputStream is) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer channelsBuffer = stack.mallocInt(1);
            IntBuffer sampleRateBuffer = stack.mallocInt(1);
            ByteBuffer mem = ByteBuffer.allocateDirect(1000000);
            Throwable throwable2 = null;
            Object var9_12 = null;
            try (BufferedInputStream bis = new BufferedInputStream(is);){
                mem.put(bis.readAllBytes());
                mem.rewind();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            this.rawAudioBuffer = STBVorbis.stb_vorbis_decode_memory(mem, channelsBuffer, sampleRateBuffer);
            this.channels = channelsBuffer.get(0);
            this.sampleRate = sampleRateBuffer.get(0);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public int getChannels() {
        return this.channels;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public ShortBuffer getData() {
        return this.rawAudioBuffer;
    }

    public double getDuration() {
        return (double)this.rawAudioBuffer.remaining() / (double)(this.sampleRate * this.channels);
    }

    @Override
    public void close() {
        if (this.rawAudioBuffer != null) {
            LibCStdlib.free(this.rawAudioBuffer);
        }
    }
}

