/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.sound_lwjgl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.comp_lot.glui.sound.SoundEnum;
import net.comp_lot.glui.sound_lwjgl.SoundRawData;
import org.lwjgl.openal.AL10;

class SoundManager
implements Closeable {
    private final List<SoundBuffer> sounds = new ArrayList<SoundBuffer>();

    public SoundManager() {
        Arrays.stream(SoundEnum.values()).forEach(e -> e.setId(this.registerSound(this.getClass().getResourceAsStream(e.getFile()))));
    }

    public int registerSound(InputStream is) {
        this.sounds.add(new SoundBuffer(is));
        return this.sounds.size() - 1;
    }

    @Override
    public void close() {
        this.sounds.parallelStream().forEach(s -> s.free());
    }

    SoundBuffer get(int i) {
        return this.sounds.get(i);
    }

    SoundBuffer get(SoundEnum e) {
        return this.sounds.get(e.ordinal());
    }

    static class SoundBuffer {
        private int bufferPointer;
        private double time;

        int getBufferPointer() {
            return this.bufferPointer;
        }

        double getTime() {
            return this.time;
        }

        private SoundBuffer(InputStream is) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (SoundRawData rawData = new SoundRawData(is);){
                    this.time = rawData.getDuration();
                    int format = -1;
                    switch (rawData.getChannels()) {
                        case 1: {
                            format = 4353;
                            break;
                        }
                        case 2: {
                            format = 4355;
                            break;
                        }
                        default: {
                            throw new IOException("Audio channel number is illegal : " + rawData.getChannels());
                        }
                    }
                    this.bufferPointer = AL10.alGenBuffers();
                    AL10.alBufferData(this.bufferPointer, format, rawData.getData(), rawData.getSampleRate());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void free() {
            AL10.alDeleteBuffers(this.bufferPointer);
        }
    }
}

