/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.sound_lwjgl;

import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.sound_lwjgl.ALSoundSource;
import net.comp_lot.glui.sound_lwjgl.SoundManager;
import net.comp_lot.glui.system.GluiConfig;
import org.lwjgl.openal.AL11;

class BufferedSoundSource
extends ALSoundSource {
    private final double time;

    BufferedSoundSource(SoundManager.SoundBuffer sound, Vector pos, Vector speed, float gain, boolean loop, GluiConfig config) {
        super(pos, speed, gain, config);
        this.time = sound.getTime();
        AL11.alSourcei(this.getSourcePointer(), 4105, sound.getBufferPointer());
        AL11.alSourcei(this.getSourcePointer(), 4103, loop ? 1 : 0);
        AL11.alSourcePlay(this.getSourcePointer());
    }

    @Override
    public boolean update() {
        if (!this.isPlaying()) {
            this.free();
            return true;
        }
        return false;
    }

    @Override
    public boolean isPlaying() {
        return !this.isStopped() && AL11.alGetSourcei(this.getSourcePointer(), 4112) == 4114;
    }

    @Override
    public double getRemainSecond() {
        return this.time < 0.0 ? 0.0 : (this.isPlaying() ? this.time - (double)AL11.alGetSourcef(this.getSourcePointer(), 4132) : 0.0);
    }
}

