/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.sound_lwjgl;

import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.sound.SoundSource;
import net.comp_lot.glui.system.GluiConfig;
import org.lwjgl.openal.AL10;

abstract class ALSoundSource
extends SoundSource {
    private final GluiConfig config;
    private final int sourcePointer;
    private boolean stop = false;

    ALSoundSource(Vector pos, Vector speed, float gain, GluiConfig config) {
        this.config = config;
        this.sourcePointer = AL10.alGenSources();
        AL10.alSourcef(this.getSourcePointer(), 4099, 1.0f);
        AL10.alSourcef(this.getSourcePointer(), 4106, gain * config.getVolumeOut());
        AL10.alSource3f(this.getSourcePointer(), 4100, (float)pos.getX() * config.getAlUnit(), (float)pos.getY() * config.getAlUnit(), (float)(-pos.getZ()) * config.getAlUnit());
        AL10.alSource3f(this.getSourcePointer(), 4102, (float)speed.getX() * config.getAlUnit(), (float)speed.getY() * config.getAlUnit(), (float)(-speed.getZ()) * config.getAlUnit());
    }

    public GluiConfig getConfig() {
        return this.config;
    }

    protected int getSourcePointer() {
        return this.sourcePointer;
    }

    abstract boolean update();

    @Override
    public void stop() {
        this.stop = true;
    }

    protected boolean isStopped() {
        return this.stop;
    }

    @Override
    public void setGain(float gain) {
        AL10.alSourcef(this.getSourcePointer(), 4106, gain * this.getConfig().getVolumeOut());
    }

    protected void free() {
        AL10.alDeleteSources(this.getSourcePointer());
    }
}

