/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.glui.sound_lwjgl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.sound.AudioSystem;
import net.comp_lot.glui.sound_lwjgl.ALSoundSource;
import net.comp_lot.glui.sound_lwjgl.BufferedSoundSource;
import net.comp_lot.glui.sound_lwjgl.SoundManager;
import net.comp_lot.glui.sound_lwjgl.StreamingSoundFrame;
import net.comp_lot.glui.sound_lwjgl.StreamingSoundSource;
import net.comp_lot.glui.system.GluiConfig;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.ALCapabilities;

public class ALAudioSystem
extends AudioSystem {
    private final GluiConfig config;
    private final long device;
    private final long context;
    private final SoundManager soundManager;
    private final List<ALSoundSource> sources = new ArrayList<ALSoundSource>();
    private final Map<Integer, StreamingSoundSource> buffer = new HashMap<Integer, StreamingSoundSource>();

    public ALAudioSystem(GluiConfig config, boolean useHrtf) {
        this.config = config;
        String defaultDeviceName = ALC10.alcGetString(0L, 4100);
        this.device = ALC10.alcOpenDevice(defaultDeviceName);
        int[] attributes = new int[1];
        if (useHrtf) {
            int[] nArray = new int[3];
            nArray[0] = 6546;
            nArray[1] = 1;
            attributes = nArray;
        }
        this.context = ALC10.alcCreateContext(this.device, attributes);
        ALC10.alcMakeContextCurrent(this.context);
        ALCCapabilities alcCapabilities = ALC.createCapabilities(this.device);
        ALCapabilities alCapabilities = AL.createCapabilities(alcCapabilities);
        AL10.alDistanceModel(53250);
        this.soundManager = new SoundManager();
    }

    @Override
    public void close() {
        this.soundManager.close();
        ALC10.alcDestroyContext(this.context);
        ALC10.alcCloseDevice(this.device);
    }

    @Override
    public void update() {
        this.sources.removeIf(s -> s.update());
        this.buffer.values().retainAll(this.sources);
    }

    @Override
    public ALSoundSource playSound(int soundNum, Vector pos, Vector speed, float gain, boolean loop) {
        BufferedSoundSource soundSource = new BufferedSoundSource(this.soundManager.get(soundNum), pos, speed, gain, loop, this.config);
        this.sources.add(soundSource);
        return soundSource;
    }

    @Override
    public int registerSound(InputStream is) {
        return this.soundManager.registerSound(is);
    }

    public void playStream(int id, StreamingSoundFrame frame) {
        if (!this.buffer.containsKey(id)) {
            this.playStream(id);
        }
        this.buffer.get(id).add(frame);
    }

    private void playStream(int num) {
        StreamingSoundSource streamingSource = new StreamingSoundSource(Vector.ZERO, Vector.ZERO, 1.0f, this.config);
        this.sources.add(streamingSource);
        this.buffer.put(num, streamingSource);
    }

    @Override
    public void setListener(Vector pos, Vector at, Vector up, Vector speed) {
        AL10.alListener3f(4100, (float)pos.getX() * this.config.getAlUnit(), (float)pos.getY() * this.config.getAlUnit(), (float)(-pos.getZ()) * this.config.getAlUnit());
        AL10.alListener3f(4102, (float)speed.getX() * this.config.getAlUnit(), (float)speed.getY() * this.config.getAlUnit(), (float)(-speed.getZ()) * this.config.getAlUnit());
        float[] data = new float[]{(float)at.getX() * this.config.getAlUnit(), (float)at.getY() * this.config.getAlUnit(), (float)(-at.getZ()) * this.config.getAlUnit(), (float)up.getX() * this.config.getAlUnit(), (float)up.getY() * this.config.getAlUnit(), (float)(-up.getZ()) * this.config.getAlUnit()};
        AL10.alListenerfv(4111, data);
    }
}

